/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.story;

import android.net.Uri;
import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.api.social.story.AmityStoryAnalytics;
import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption;
import com.amity.socialcloud.sdk.api.social.storytarget.AmityGlobalStoryTargetsQueryOption;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryImageDisplayMode;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget;
import com.amity.socialcloud.sdk.social.domain.story.StoryLiveObjectUseCase;
import com.amity.socialcloud.sdk.social.domain.story.create.CreateImageStoryUseCase;
import com.amity.socialcloud.sdk.social.domain.story.create.CreateVideoStoryUseCase;
import com.amity.socialcloud.sdk.social.domain.story.delete.DeleteStoryUseCase;
import com.amity.socialcloud.sdk.social.domain.story.query.GetActiveStoriesUseCase;
import com.amity.socialcloud.sdk.social.domain.story.query.GetStoriesByTargetsUseCase;
import com.amity.socialcloud.sdk.social.domain.storytarget.get.GetGlobalStoryTargetsUseCase;
import com.amity.socialcloud.sdk.social.domain.storytarget.get.GetStoryTargetsUseCase;
import com.amity.socialcloud.sdk.social.domain.storytarget.get.StoryTargetLiveObjectUseCase;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J:\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ,\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\r0\u00162\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u001a0\rJ\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001c0\u00162\u0006\u0010\u001d\u001a\u00020\u001eJ,\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001c0\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010!\u001a\u00020\"J6\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\r0\u00162\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u001a0\r2\b\b\u0002\u0010!\u001a\u00020\"J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u00162\u0006\u0010%\u001a\u00020\tJ\u000e\u0010&\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\tJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020 \u00a8\u0006+"}, d2={"Lcom/amity/socialcloud/sdk/api/social/story/AmityStoryRepository;", "", "<init>", "()V", "createImageStory", "Lio/reactivex/rxjava3/core/Completable;", "targetType", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$TargetType;", "targetId", "", "imageUri", "Landroid/net/Uri;", "storyItems", "", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryItem;", "imageDisplayMode", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryImageDisplayMode;", "metadata", "Lcom/google/gson/JsonObject;", "createVideoStory", "videoUri", "getStoryTarget", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryTarget;", "getStoryTargets", "targets", "Lkotlin/Pair;", "getGlobalStoryTargets", "Landroidx/paging/PagingData;", "queryOption", "Lcom/amity/socialcloud/sdk/api/social/storytarget/AmityGlobalStoryTargetsQueryOption;", "getActiveStories", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory;", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/story/AmityStorySortOption;", "getStoriesByTargets", "getStory", "storyId", "softDeleteStory", "hardDeleteStory", "analytics", "Lcom/amity/socialcloud/sdk/api/social/story/AmityStoryAnalytics;", "story", "amity-sdk_release"})
public final class AmityStoryRepository {
    @NotNull
    public final Completable createImageStory(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull Uri imageUri, @NotNull List<? extends AmityStoryItem> storyItems, @NotNull AmityStoryImageDisplayMode imageDisplayMode, @Nullable JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        Intrinsics.checkNotNullParameter((Object)((Object)imageDisplayMode), (String)"imageDisplayMode");
        return new CreateImageStoryUseCase().execute(targetType, targetId, imageUri, storyItems, metadata, imageDisplayMode);
    }

    public static /* synthetic */ Completable createImageStory$default(AmityStoryRepository amityStoryRepository, AmityStory.TargetType targetType, String string, Uri uri, List list, AmityStoryImageDisplayMode amityStoryImageDisplayMode, JsonObject jsonObject, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            amityStoryImageDisplayMode = AmityStoryImageDisplayMode.FIT;
        }
        if ((n & 0x20) != 0) {
            jsonObject = null;
        }
        return amityStoryRepository.createImageStory(targetType, string, uri, list, amityStoryImageDisplayMode, jsonObject);
    }

    @NotNull
    public final Completable createVideoStory(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull Uri videoUri, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)videoUri, (String)"videoUri");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        return new CreateVideoStoryUseCase().execute(targetType, targetId, videoUri, storyItems, metadata);
    }

    public static /* synthetic */ Completable createVideoStory$default(AmityStoryRepository amityStoryRepository, AmityStory.TargetType targetType, String string, Uri uri, List list, JsonObject jsonObject, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            jsonObject = null;
        }
        return amityStoryRepository.createVideoStory(targetType, string, uri, list, jsonObject);
    }

    @NotNull
    public final Flowable<AmityStoryTarget> getStoryTarget(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return new StoryTargetLiveObjectUseCase().execute(AmityStoryTarget.Companion.generateUniqueId$amity_sdk_release(targetType.getApiKey(), targetId));
    }

    @NotNull
    public final Flowable<List<AmityStoryTarget>> getStoryTargets(@NotNull List<? extends Pair<? extends AmityStory.TargetType, String>> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        return new GetStoryTargetsUseCase().execute(targets);
    }

    @NotNull
    public final Flowable<PagingData<AmityStoryTarget>> getGlobalStoryTargets(@NotNull AmityGlobalStoryTargetsQueryOption queryOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)queryOption), (String)"queryOption");
        return new GetGlobalStoryTargetsUseCase().execute(queryOption);
    }

    @NotNull
    public final Flowable<PagingData<AmityStory>> getActiveStories(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull AmityStorySortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return new GetActiveStoriesUseCase().execute(targetType, targetId, sortOption);
    }

    public static /* synthetic */ Flowable getActiveStories$default(AmityStoryRepository amityStoryRepository, AmityStory.TargetType targetType, String string, AmityStorySortOption amityStorySortOption, int n, Object object) {
        if ((n & 4) != 0) {
            amityStorySortOption = AmityStorySortOption.FIRST_CREATED;
        }
        return amityStoryRepository.getActiveStories(targetType, string, amityStorySortOption);
    }

    @NotNull
    public final Flowable<List<AmityStory>> getStoriesByTargets(@NotNull List<? extends Pair<? extends AmityStory.TargetType, String>> targets, @NotNull AmityStorySortOption sortOption) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return new GetStoriesByTargetsUseCase().execute(targets, sortOption);
    }

    public static /* synthetic */ Flowable getStoriesByTargets$default(AmityStoryRepository amityStoryRepository, List list, AmityStorySortOption amityStorySortOption, int n, Object object) {
        if ((n & 2) != 0) {
            amityStorySortOption = AmityStorySortOption.FIRST_CREATED;
        }
        return amityStoryRepository.getStoriesByTargets(list, amityStorySortOption);
    }

    @NotNull
    public final Flowable<AmityStory> getStory(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return new StoryLiveObjectUseCase().execute(storyId);
    }

    @NotNull
    public final Completable softDeleteStory(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return new DeleteStoryUseCase().execute(storyId, false);
    }

    @NotNull
    public final Completable hardDeleteStory(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return new DeleteStoryUseCase().execute(storyId, true);
    }

    @NotNull
    public final AmityStoryAnalytics analytics(@NotNull AmityStory story) {
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        return new AmityStoryAnalytics(story);
    }
}

