package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "channel_read_receipt", primaryKeys = ["channelId"])
open class ChannelReadReceiptEntity : EkoObject() {

    var channelId: String = ObjectId.get().toHexString()
    var latestSegment: Int = 0
    var latestSyncSegment: Int = 0

    override fun getId(): String {
        return channelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is ChannelReadReceiptEntity
            && Objects.equal(channelId, other.channelId)
            && Objects.equal(latestSegment, other.latestSegment)
            && Objects.equal(latestSyncSegment, other.latestSyncSegment)
            && Objects.equal(createdAt, other.createdAt)
            && Objects.equal(updatedAt, other.updatedAt)
            )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            channelId,
            latestSegment,
            latestSyncSegment,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("channelId", channelId)
            add("latestSegment", latestSegment)
            add("latestSyncSegment", latestSyncSegment)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}