package com.amity.socialcloud.sdk.social.domain.event.create

import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventType
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.social.data.event.EventRepository
import com.amity.socialcloud.sdk.social.domain.event.EventComposerUseCase
import io.reactivex.rxjava3.core.Single
import org.joda.time.DateTime

internal class EventCreateUseCase {

    fun execute(
        title: String?,
        description: String?,
        type: AmityEventType?,
        isInviteOnly: Boolean?,
        startTime: DateTime?,
        endTime: DateTime?,
        originType: AmityEventOriginType,
        originId: String,
        location: String?,
        externalUrl: String?,
        coverImageFileId: String?,
        tags: AmityTags?,
        timezone: String?
    ): Single<AmityEvent> {
        return EventRepository()
            .createEvent(
                title = title,
                description = description,
                type = type,
                isInviteOnly = isInviteOnly,
                startTime = startTime,
                endTime = endTime,
                originType = originType,
                originId = originId,
                location = location,
                externalUrl = externalUrl,
                coverImageFileId = coverImageFileId,
                tags = tags,
                timezone = timezone
            )
            .map { EventComposerUseCase().execute(it) }
    }
}
