package com.amity.socialcloud.sdk.model.social.event

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityEvent internal constructor(
    private val publicId: String = ObjectId.get().toHexString(),
    private val eventId: String = ObjectId.get().toHexString(),
    private val title: String,
    private val description: String,
    private val type: AmityEventType,
    private val status: AmityEventStatus,
    private val startTime: DateTime,
    private val endTime: DateTime?,
    private val coverImageFileId: String?,
    internal var coverImage: AmityImage?,
    private val originType: AmityEventOriginType,
    private val originId: String,
    private val livestreamId: String?,
    internal var liveStream: AmityStream?,
    private val userId: String,
    internal var creator: AmityUser?,
    internal var discussionCommunity: AmityCommunity?,
    private val rsvpCount: Int,
    private val interestedCount: Int,
    private val isLocationVisible: Boolean,
    private val location: String?,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
    internal val path: String
) : Parcelable, ReactorObject {

    fun getPublicId(): String {
        return publicId
    }

    fun getEventId(): String {
        return eventId
    }

    fun getTitle(): String {
        return title
    }

    fun getDescription(): String {
        return description
    }

    fun getType(): AmityEventType {
        return type
    }

    fun getStatus(): AmityEventStatus {
        return status
    }

    fun getStartTime(): DateTime {
        return startTime
    }

    fun getEndTime(): DateTime? {
        return endTime
    }

    fun getCoverImageFileId(): String? {
        return coverImageFileId
    }

    fun getCoverImage(): AmityImage? {
        return coverImage
    }

    fun getOriginType(): AmityEventOriginType {
        return originType
    }

    fun getOriginId(): String {
        return originId
    }

    fun getLivestreamId(): String? {
        return livestreamId
    }

    fun getLiveStream(): AmityStream? {
        return liveStream
    }

    fun getUserId(): String {
        return userId
    }

    fun getCreator(): AmityUser? {
        return creator
    }

    fun getDiscussionCommunity(): AmityCommunity? {
        return discussionCommunity
    }

    fun getRsvpCount(): Int {
        return rsvpCount
    }

    fun getInterestedCount(): Int {
        return interestedCount
    }

    fun isLocationVisible(): Boolean {
        return isLocationVisible
    }

    fun getLocation(): String? {
        return location
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return eventId
    }
}
