package com.amity.socialcloud.sdk.model.chat.settings

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class AmitySocialSettings internal constructor(
    private val isEnabled: Boolean,
    private val story: AmitySocialStorySettings,
    private val membershipAcceptance: AmityMembershipAcceptanceType,
) : Parcelable {

    fun isEnabled(): Boolean {
        return isEnabled
    }

    fun getStorySettings(): AmitySocialStorySettings {
        return story
    }

    fun getMembershipAcceptanceType(): AmityMembershipAcceptanceType {
        return membershipAcceptance
    }
}