package com.amity.socialcloud.sdk.core.data.notificationtray.notificationtrayseen

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.core.data.notificationtray.NotificationTrayRemoteDataStore
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTraySeenEntity
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTraySeen
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

internal class NotificationTraySeenRepository :
    AmityObjectRepository<NotificationTraySeenEntity, AmityNotificationTraySeen>() {
    override fun fetchAndSave(objectId: String): Completable {
        return NotificationTrayRemoteDataStore().getNotificationTraySeen()
            .flatMapCompletable {
                NotificationTraySeenPersister().persist(it)
            }.onErrorResumeNext {
                Completable.error(it)
            }
    }

    override fun queryFromCache(objectId: String): NotificationTraySeenEntity? {
        return NotificationTraySeenLocalDataStore().getNotificationTraySeen()
    }

    override fun mapper(): ModelMapper<NotificationTraySeenEntity, AmityNotificationTraySeen> {
        return NotificationTraySeenModelMapper()
    }

    override fun observeFromCache(objectId: String): Flowable<NotificationTraySeenEntity> {
        return NotificationTraySeenLocalDataStore().observe(AmityCoreClient.getUserId())
    }

    fun markTraySeen(): Completable {
        return NotificationTrayRemoteDataStore().markTraySeen()
            .flatMapCompletable {
                NotificationTraySeenLocalDataStore().updateNotificationTraySeen(
                    it.lastTraySeenAt ?: DateTime.now()
                )
            }.onErrorResumeNext {
                Completable.error(it)
            }
    }

}