package com.amity.socialcloud.sdk.helper.core.hashtag

import com.google.gson.Gson
import com.google.gson.JsonObject

class AmityHashtagMetadataGetter constructor(private val metadata: JsonObject) {

    fun getHashtags(): List<AmityHashtag> {
        return try {
            metadata.getAsJsonArray("hashtags")
        } catch (e: Exception) {
            // Return null if no hashtags are found or if the metadata is malformed
            null
        }?.let { hashtags ->
            try {
                hashtags.map {
                    Gson().fromJson(it, AmityHashtag::class.java)
                }
            } catch (e: Exception) {
                // If parsing fails, return an empty list
                emptyList()
            }
        } ?: emptyList()
    }
}
