package com.amity.socialcloud.sdk.api.social.comment.update

import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.ekoapp.ekosdk.internal.usecase.comment.EditCommentUseCase
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

abstract class AmityCommentUpdate internal constructor(
    private val commentId: String,
    private val metadata: JsonObject?,
    private val mentionees: List<AmityMentioneeTarget>?
) {

    internal abstract fun getData(): JsonObject?

    internal abstract fun getAttachments(): JsonArray?


    /**
     * Updates a comment
     * @return Async comment as Single<AmityComment>
     */
    fun apply(): Single<AmityComment> {
        return EditCommentUseCase().execute(
            commentId,
            getData(),
            getAttachments(),
            metadata,
            mentionees
        )
    }
}