package com.amity.socialcloud.sdk.chat.data.subchannel

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.SubChannelEntity
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto
import org.joda.time.DateTime

internal class SubChannelEntityMapper : EntityMapper<SubChannelDto, SubChannelEntity>() {

    override fun map(list: List<SubChannelDto>): List<SubChannelEntity> {
        return list.map { map(it) }
    }

    fun map(dto: SubChannelDto): SubChannelEntity {
        return SubChannelEntity().apply {
            subChannelId = dto.subChannelId ?: ""
            channelId = dto.channelId ?: ""
            channelPublicId = dto.channelPublicId ?: ""
            networkId = dto.networkId ?: ""
            channelType = dto.channelType ?: "community"
            name = dto.name ?: ""
            messageCount = dto.childCount ?: 0
            isDeleted = dto.isDeleted ?: false
            latestMessageId = dto.latestMessageId ?: ""
            lastActivity = dto.lastActivity ?: DateTime.now()
            creatorId = dto.creatorId ?: ""
            creatorPublicId = dto.creatorPublicId ?: ""
            path = dto.path ?: ""
            messagePreviewId = dto.messagePreviewId
            editedAt = dto.editedAt ?: dto.createdAt
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
        }
    }
}