/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;

@Entity(tableName="http_url")
public class EkoHttpUrl {
    private static final String SINGLETON_HTTP_URL_ID = "SINGLETON_HTTP_URL_ID";
    @PrimaryKey
    @NonNull
    private String id = EkoHttpUrl.currentHttpUrlId();
    private String httpUrl;
    private long updateAt = System.currentTimeMillis();

    public static String currentHttpUrlId() {
        return SINGLETON_HTTP_URL_ID;
    }

    @NonNull
    public String getId() {
        return EkoHttpUrl.currentHttpUrlId();
    }

    public void setId(String id) {
        this.id = EkoHttpUrl.currentHttpUrlId();
    }

    @NonNull
    public String getHttpUrl() {
        return this.httpUrl;
    }

    public void setHttpUrl(@NonNull String httpUrl) {
        this.httpUrl = EkoPreconditions.checkValidId(httpUrl, "httpUrl");
    }

    public long getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public static EkoHttpUrl create(@NonNull String url) {
        EkoHttpUrl ekoHttpUrl = new EkoHttpUrl();
        ekoHttpUrl.setHttpUrl(url);
        return ekoHttpUrl;
    }
}

