package com.ekoapp.ekosdk.internal.data.model

import co.amity.rxremotemediator.AmityQueryToken
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembership
import com.amity.socialcloud.sdk.model.core.role.AmityRoles

class ChannelMembershipSearchQueryToken(
    var channelId: String = "",
    var roles: AmityRoles = AmityRoles(),
    var filters: List<AmityChannelMembership> = listOf(),
    var keyword: String? = null,
    next: String? = null,
    previous: String? = null,
    ids: List<String> = listOf()
) : AmityQueryToken(
    queryParameters = mapOf(
        "channelId" to channelId,
        "roles" to roles,
        "memberships" to filters,
        "search" to (keyword ?: "")
    ),
    next = next,
    previous = previous,
    primaryKeys = ids
)