/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.EmptyResultSetException;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoFileDao_Impl
extends EkoFileDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoFileEntity> __insertionAdapterOfEkoFileEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoFileEntity> __deletionAdapterOfEkoFileEntity;
    private final EntityDeletionOrUpdateAdapter<EkoFileEntity> __updateAdapterOfEkoFileEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoFileDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoFileEntity = new EntityInsertionAdapter<EkoFileEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `file` (`fileId`,`fileUrl`,`filePath`,`type`,`accessType`,`attributes`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFileEntity value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
                if (value.getFileUrl() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFileUrl());
                }
                if (value.getFilePath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFilePath());
                }
                if (value.getType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getType());
                }
                if (value.getAccessType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAccessType());
                }
                String _tmp = EkoFileDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getAttributes());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                String _tmp_1 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                String _tmp_2 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfEkoFileEntity = new EntityDeletionOrUpdateAdapter<EkoFileEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `file` WHERE `fileId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFileEntity value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
            }
        };
        this.__updateAdapterOfEkoFileEntity = new EntityDeletionOrUpdateAdapter<EkoFileEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `file` SET `fileId` = ?,`fileUrl` = ?,`filePath` = ?,`type` = ?,`accessType` = ?,`attributes` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `fileId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFileEntity value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
                if (value.getFileUrl() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFileUrl());
                }
                if (value.getFilePath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFilePath());
                }
                if (value.getType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getType());
                }
                if (value.getAccessType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAccessType());
                }
                String _tmp = EkoFileDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getAttributes());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                String _tmp_1 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                String _tmp_2 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                if (value.getFileId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getFileId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from file";
                return "DELETE from file";
            }
        };
    }

    @Override
    public void insertImpl(EkoFileEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoFileEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends EkoFileEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoFileEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoFileEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoFileEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends EkoFileEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoFileEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(EkoFileEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoFileEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoFileEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFileDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends EkoFileEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoFileDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoFileEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFileDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Single<List<EkoFileEntity>> getByIdImpl(String fileId) {
        String _sql = "SELECT * from file where file.fileId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from file where file.fileId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (fileId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, fileId);
        }
        return RxRoom.createSingle((Callable)new Callable<List<EkoFileEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoFileEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoFileDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileId");
                    int _cursorIndexOfFileUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileUrl");
                    int _cursorIndexOfFilePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"filePath");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfAccessType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessType");
                    int _cursorIndexOfAttributes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attributes");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<EkoFileEntity> _result = new ArrayList<EkoFileEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoFileEntity _item = new EkoFileEntity();
                        String _tmpFileId = _cursor.isNull(_cursorIndexOfFileId) ? null : _cursor.getString(_cursorIndexOfFileId);
                        _item.setFileId(_tmpFileId);
                        String _tmpFileUrl = _cursor.isNull(_cursorIndexOfFileUrl) ? null : _cursor.getString(_cursorIndexOfFileUrl);
                        _item.setFileUrl(_tmpFileUrl);
                        String _tmpFilePath = _cursor.isNull(_cursorIndexOfFilePath) ? null : _cursor.getString(_cursorIndexOfFilePath);
                        _item.setFilePath(_tmpFilePath);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _item.setType(_tmpType);
                        String _tmpAccessType = _cursor.isNull(_cursorIndexOfAccessType) ? null : _cursor.getString(_cursorIndexOfAccessType);
                        _item.setAccessType(_tmpAccessType);
                        String _tmp = _cursor.isNull(_cursorIndexOfAttributes) ? null : _cursor.getString(_cursorIndexOfAttributes);
                        JsonObject _tmpAttributes = EkoFileDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _item.setAttributes(_tmpAttributes);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoFileDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoFileDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoFileDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    if (_result == null) {
                        throw new EmptyResultSetException("Query returned empty result set: " + _statement.getSql());
                    }
                    ArrayList<EkoFileEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoFileEntity getByIdNowImpl(String fileId) {
        String _sql = "SELECT * from file where file.fileId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from file where file.fileId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (fileId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, fileId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoFileEntity _result;
            int _cursorIndexOfFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileId");
            int _cursorIndexOfFileUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileUrl");
            int _cursorIndexOfFilePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"filePath");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfAccessType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessType");
            int _cursorIndexOfAttributes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attributes");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoFileEntity();
                String _tmpFileId = _cursor.isNull(_cursorIndexOfFileId) ? null : _cursor.getString(_cursorIndexOfFileId);
                _result.setFileId(_tmpFileId);
                String _tmpFileUrl = _cursor.isNull(_cursorIndexOfFileUrl) ? null : _cursor.getString(_cursorIndexOfFileUrl);
                _result.setFileUrl(_tmpFileUrl);
                String _tmpFilePath = _cursor.isNull(_cursorIndexOfFilePath) ? null : _cursor.getString(_cursorIndexOfFilePath);
                _result.setFilePath(_tmpFilePath);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _result.setType(_tmpType);
                String _tmpAccessType = _cursor.isNull(_cursorIndexOfAccessType) ? null : _cursor.getString(_cursorIndexOfAccessType);
                _result.setAccessType(_tmpAccessType);
                String _tmp = _cursor.isNull(_cursorIndexOfAttributes) ? null : _cursor.getString(_cursorIndexOfAttributes);
                JsonObject _tmpAttributes = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setAttributes(_tmpAttributes);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            EkoFileEntity ekoFileEntity = _result;
            return ekoFileEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoFileEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from file where file.fileId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileId");
            int _cursorIndexOfFileUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileUrl");
            int _cursorIndexOfFilePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"filePath");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfAccessType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessType");
            int _cursorIndexOfAttributes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attributes");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<EkoFileEntity> _result = new ArrayList<EkoFileEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoFileEntity _item_1 = new EkoFileEntity();
                String _tmpFileId = _cursor.isNull(_cursorIndexOfFileId) ? null : _cursor.getString(_cursorIndexOfFileId);
                _item_1.setFileId(_tmpFileId);
                String _tmpFileUrl = _cursor.isNull(_cursorIndexOfFileUrl) ? null : _cursor.getString(_cursorIndexOfFileUrl);
                _item_1.setFileUrl(_tmpFileUrl);
                String _tmpFilePath = _cursor.isNull(_cursorIndexOfFilePath) ? null : _cursor.getString(_cursorIndexOfFilePath);
                _item_1.setFilePath(_tmpFilePath);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmpAccessType = _cursor.isNull(_cursorIndexOfAccessType) ? null : _cursor.getString(_cursorIndexOfAccessType);
                _item_1.setAccessType(_tmpAccessType);
                String _tmp = _cursor.isNull(_cursorIndexOfAttributes) ? null : _cursor.getString(_cursorIndexOfAttributes);
                JsonObject _tmpAttributes = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setAttributes(_tmpAttributes);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<EkoFileEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

