package com.amity.socialcloud.sdk.model.core.follow


enum class AmityFollowStatusFilter(val apiKey: String,
                                   val statuses: List<String>) {
    ALL("all", listOf(AmityFollowStatus.ACCEPTED.apiKey, AmityFollowStatus.PENDING.apiKey)),
    ACCEPTED("accepted", listOf(AmityFollowStatus.ACCEPTED.apiKey)),
    PENDING("pending", listOf(AmityFollowStatus.PENDING.apiKey));

    companion object {
        fun enumOf(value: String?): AmityFollowStatusFilter {
            return values().find { it.apiKey == value } ?: ALL
        }
    }
}