package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto

internal class ChannelLeft : ChannelEventListener() {

    override fun getEventName(): String {
        return "channel.left"
    }
    
    override fun processEvent(dto: ChannelEventDto) {
        val processDto = if (!isActiveUserRemovedEvent(dto)) {
            dto.copy (
                    channelDtoList = dto.channelDtoList.map {
                        it.copy(
                                messagePreviewId = ChannelRepository().getMessagePreviewId(it.channelId)
                        )
                    }
            )
        } else dto
        super.processEvent(processDto)
        if (isActiveUserRemovedEvent(processDto)) {
            MarkerEventBus.publish(MarkerEvent.ChannelLeft(getEventName(), processDto))
        }
    }

}