package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import io.reactivex.rxjava3.core.Single

internal class JoinChannelUseCase {

    fun execute(channelId: String): Single<AmityChannel> {
        return ChannelRepository().joinChannel(channelId)
            .map {
                ChannelComposerUseCase().execute(it)
            }
    }

}