/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.ad;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.EmptyResultSetException;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.data.ad.AdsSettingsDao;
import com.amity.socialcloud.sdk.entity.core.ad.AdsSettingsEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class AdsSettingsDao_Impl
extends AdsSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AdsSettingsEntity> __insertionAdapterOfAdsSettingsEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<AdsSettingsEntity> __deletionAdapterOfAdsSettingsEntity;
    private final EntityDeletionOrUpdateAdapter<AdsSettingsEntity> __updateAdapterOfAdsSettingsEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public AdsSettingsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAdsSettingsEntity = new EntityInsertionAdapter<AdsSettingsEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ads_settings` (`settingId`,`enabled`,`maxActiveAds`,`frequency`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AdsSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.getEnabled() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                stmt.bindLong(3, (long)value.getMaxActiveAds());
                String _tmp_1 = AdsSettingsDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getFrequency());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfAdsSettingsEntity = new EntityDeletionOrUpdateAdapter<AdsSettingsEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `ads_settings` WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AdsSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
            }
        };
        this.__updateAdapterOfAdsSettingsEntity = new EntityDeletionOrUpdateAdapter<AdsSettingsEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `ads_settings` SET `settingId` = ?,`enabled` = ?,`maxActiveAds` = ?,`frequency` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AdsSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.getEnabled() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                stmt.bindLong(3, (long)value.getMaxActiveAds());
                String _tmp_1 = AdsSettingsDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getFrequency());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
                if (value.getSettingId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSettingId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from ads_settings";
                return "DELETE from ads_settings";
            }
        };
    }

    @Override
    public void insertImpl(AdsSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfAdsSettingsEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends AdsSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfAdsSettingsEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(AdsSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfAdsSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends AdsSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfAdsSettingsEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(AdsSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfAdsSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(AdsSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            AdsSettingsDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends AdsSettingsEntity> objects) {
        this.__db.beginTransaction();
        try {
            AdsSettingsDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(AdsSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            AdsSettingsDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Single<List<AdsSettingsEntity>> getByIdImpl(String id) {
        String _sql = "SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return RxRoom.createSingle((Callable)new Callable<List<AdsSettingsEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AdsSettingsEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AdsSettingsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfSettingId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"settingId");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                    int _cursorIndexOfMaxActiveAds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxActiveAds");
                    int _cursorIndexOfFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequency");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<AdsSettingsEntity> _result = new ArrayList<AdsSettingsEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpSettingId = _cursor.isNull(_cursorIndexOfSettingId) ? null : _cursor.getString(_cursorIndexOfSettingId);
                        int _tmp = _cursor.getInt(_cursorIndexOfEnabled);
                        boolean _tmpEnabled = _tmp != 0;
                        int _tmpMaxActiveAds = _cursor.getInt(_cursorIndexOfMaxActiveAds);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfFrequency) ? null : _cursor.getString(_cursorIndexOfFrequency);
                        JsonObject _tmpFrequency = AdsSettingsDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                        AdsSettingsEntity _item = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    if (_result == null) {
                        throw new EmptyResultSetException("Query returned empty result set: " + _statement.getSql());
                    }
                    ArrayList<AdsSettingsEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdsSettingsEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            AdsSettingsEntity _result;
            int _cursorIndexOfSettingId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"settingId");
            int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
            int _cursorIndexOfMaxActiveAds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxActiveAds");
            int _cursorIndexOfFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequency");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpSettingId = _cursor.isNull(_cursorIndexOfSettingId) ? null : _cursor.getString(_cursorIndexOfSettingId);
                int _tmp = _cursor.getInt(_cursorIndexOfEnabled);
                boolean _tmpEnabled = _tmp != 0;
                int _tmpMaxActiveAds = _cursor.getInt(_cursorIndexOfMaxActiveAds);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfFrequency) ? null : _cursor.getString(_cursorIndexOfFrequency);
                JsonObject _tmpFrequency = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _result = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            AdsSettingsEntity adsSettingsEntity = _result;
            return adsSettingsEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdsSettingsEntity getNowImpl() {
        String _sql = "SELECT * from ads_settings LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ads_settings LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            AdsSettingsEntity _result;
            int _cursorIndexOfSettingId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"settingId");
            int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
            int _cursorIndexOfMaxActiveAds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxActiveAds");
            int _cursorIndexOfFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequency");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpSettingId = _cursor.isNull(_cursorIndexOfSettingId) ? null : _cursor.getString(_cursorIndexOfSettingId);
                int _tmp = _cursor.getInt(_cursorIndexOfEnabled);
                boolean _tmpEnabled = _tmp != 0;
                int _tmpMaxActiveAds = _cursor.getInt(_cursorIndexOfMaxActiveAds);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfFrequency) ? null : _cursor.getString(_cursorIndexOfFrequency);
                JsonObject _tmpFrequency = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _result = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            AdsSettingsEntity adsSettingsEntity = _result;
            return adsSettingsEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AdsSettingsEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from ads_settings where ads_settings.settingId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfSettingId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"settingId");
            int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
            int _cursorIndexOfMaxActiveAds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxActiveAds");
            int _cursorIndexOfFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequency");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<AdsSettingsEntity> _result = new ArrayList<AdsSettingsEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpSettingId = _cursor.isNull(_cursorIndexOfSettingId) ? null : _cursor.getString(_cursorIndexOfSettingId);
                int _tmp = _cursor.getInt(_cursorIndexOfEnabled);
                boolean _tmpEnabled = _tmp != 0;
                int _tmpMaxActiveAds = _cursor.getInt(_cursorIndexOfMaxActiveAds);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfFrequency) ? null : _cursor.getString(_cursorIndexOfFrequency);
                JsonObject _tmpFrequency = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                AdsSettingsEntity _item_1 = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<AdsSettingsEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

