package com.amity.socialcloud.sdk.core.data.notification.channel

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoPushNotificationEventDto
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class ChannelNotificationRemoteDataStore {

    fun getSetting(channelId: String): Single<EkoPushNotificationEventDto> {
        return AmityHttpClient.get(ChannelNotificationApi::class).flatMap {
            it.getSetting(channelId = channelId)
        }

    }

    fun saveSetting(channelId: String, allowed: Boolean): Single<JsonObject> {
        val request = NotificationSaveSettingsRequest.Channel(channelId, allowed)
        return AmityHttpClient.get(ChannelNotificationApi::class).flatMap {
            it.saveSetting(request)
        }
    }
}