package com.amity.socialcloud.sdk.core.domain.networksettings

import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsEntity
import com.amity.socialcloud.sdk.model.core.settings.AmityCoreUserSettings
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Flowable


internal class GetUserSettingsUseCase {
    fun execute(): Flowable<AmityCoreUserSettings> {
        val dao = UserDatabase.get().userSettingsDao()
        return dao.getUserSettings(UserSettingsEntity.USER_SETTINGS_ID).map {
            AmityCoreUserSettings(
                isAllowUpdateDisplayName = it.isAllowUpdateDisplayName,
            )
        }
    }
}