package com.amity.socialcloud.sdk.api.chat.channel.query

import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.common.collect.Sets

class AmityLiveChannelQuery private constructor(isDeleted: Boolean?,
                                                includingTags: AmityTags,
                                                excludingTags: AmityTags
)
    : AmityChannelQuery(isDeleted,
                Sets.newHashSet(AmityChannel.Type.LIVE),
                AmityChannelFilter.MEMBER,
                includingTags,
                excludingTags) {

    class Builder internal constructor() {
        private var isDeleted: Boolean? = null
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if(includeDeleted) null else false
            }
        }

        fun includingTags(includingTags: AmityTags): Builder {
            return apply { this.includingTags = includingTags }
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            return apply { this.excludingTags = excludingTags }
        }

        fun build(): AmityLiveChannelQuery {
            return AmityLiveChannelQuery( isDeleted, includingTags, excludingTags)
        }
    }
}