package com.amity.socialcloud.sdk.video.data.stream

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.dto.video.EkoStreamListDto
import com.amity.socialcloud.sdk.video.data.moderation.StreamModerationEntityMapper
import com.amity.socialcloud.sdk.video.data.moderation.StreamModerationLocalDataStore
import io.reactivex.rxjava3.core.Completable

internal class StreamQueryPersister : QueryPersister<EkoStreamListDto>() {

    override fun persist(dto: EkoStreamListDto): Completable {
       return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
           .andThen(StreamModerationLocalDataStore().saveStreamModerations(StreamModerationEntityMapper().map(dto.streamModerations?: emptyList())))
           .andThen(StreamLocalDataStore().saveStream(StreamEntityMapper().map(dto.streams)))
    }

}