package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkerUpdatedDto
import kotlin.reflect.KClass

internal class SubChannelMarkerUpdated: MqttEventListener<SubChannelMarkerUpdatedDto>()  {

    override val type: KClass<SubChannelMarkerUpdatedDto>
        get() = SubChannelMarkerUpdatedDto::class

    override fun processEvent(dto: SubChannelMarkerUpdatedDto) {
        MarkerEventBus.publish(MarkerEvent.MarkerUpdated(getEventName()))
    }

    override fun shouldProcessEvent(dto: SubChannelMarkerUpdatedDto): Boolean {
        return true
    }
    
    override fun getEventName(): String {
        return "marker.userFeed-updated"
    }
    
}