package com.amity.socialcloud.sdk.core.data.notification.community

import com.ekoapp.ekosdk.internal.api.dto.EkoPushNotificationEventDto
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Query

interface CommunityNotificationApi {

    @GET("api/v3/notification/setting")
    fun getSetting(
        @Query("level") level: String = "community",
        @Query("communityId") communityId: String? = null,
    ): Single<EkoPushNotificationEventDto>

    @POST("api/v3/notification/setting")
    fun saveSetting(
        @Body request: NotificationSaveSettingsRequest.Community
    ): Single<JsonObject>

}