package com.amity.socialcloud.sdk.api.social.poll

import com.amity.socialcloud.sdk.api.social.poll.create.AmityPollCreator
import com.amity.socialcloud.sdk.model.social.poll.AmityPoll
import com.ekoapp.ekosdk.internal.usecase.post.PollCloseUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PollDeleteUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PollGetUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PollVoteUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

class AmityPollRepository internal constructor() {
    
    /* begin_public_function
      id: poll.create
      api_style: async
    */
    /**
     * Initiates a function chain to create a poll
     * @param [question] a pollId
     * @return new instance of AmityPollCreator.Builder
     */
    fun createPoll(question: String): AmityPollCreator.Builder {
        return AmityPollCreator.Builder(question)
    }
    /* end_public_function */
    
    /* begin_public_function
      id: poll.get
    */
    /**
     * Gets a LiveObject of poll
     * @param [pollId] a pollId
     * @return LiveObject of poll as Flowable<AmityPoll>
     */
    fun getPoll(pollId: String): Flowable<AmityPoll> {
        return PollGetUseCase().execute(pollId)
    }
    /* end_public_function */
    
    /* begin_public_function
      id: poll.close
    */
    /**
     * Closes a poll
     * @param [pollId] a pollId
     * @return Async completion as Completable
     */
    fun closePoll(pollId: String): Completable {
        return PollCloseUseCase().execute(pollId)
    }
    /* end_public_function */
    
    /* begin_public_function
      id: poll.delete
    */
    /**
     * Deletes a poll
     * @param [pollId] a pollId
     * @return Async completion as Completable
     */
    fun deletePoll(pollId: String): Completable {
        return PollDeleteUseCase().execute(pollId)
    }
    /* end_public_function */
    
    /* begin_public_function
      id: poll.vote
    */
    /**
     * Votes a poll
     * @param [pollId] a pollId
     * @param [answerIds] ids of selected answers
     * @return Async completion as Completable
     */
    fun votePoll(pollId: String, answerIds: List<String>): Completable {
        return PollVoteUseCase().execute(pollId, answerIds)
    }
    /* end_public_function */


}