package com.amity.socialcloud.sdk.api.core.file

import android.net.Uri
import com.amity.socialcloud.sdk.core.data.file.FileRepository
import com.amity.socialcloud.sdk.core.domain.file.FileDeleteUseCase
import com.amity.socialcloud.sdk.core.domain.file.RawFileGetUseCase
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType
import com.amity.socialcloud.sdk.model.core.file.AmityAudio
import com.amity.socialcloud.sdk.model.core.file.AmityFile
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile
import com.amity.socialcloud.sdk.model.core.file.AmityVideo
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single
import java.util.*

class AmityFileRepository {
    
    /* begin_public_function
	  id: file.upload.file
	  api_style: async
	*/
    fun uploadFile(uri: Uri): Flowable<AmityUploadResult<AmityFile>> {
        return uploadFile(UUID.randomUUID().toString(), uri)
    }
    /* end_public_function */

    fun uploadFile(uploadId: String, uri: Uri): Flowable<AmityUploadResult<AmityFile>> {
        return FileRepository().uploadFile(uploadId, uri)
    }
    
    /* begin_public_function
	  id: file.upload.image
	  api_style: async
	*/
    fun uploadImage(uri: Uri): Flowable<AmityUploadResult<AmityImage>> {
        return uploadImage(UUID.randomUUID().toString(), uri)
    }
    /* end_public_function */

    fun uploadImage(uploadId: String, uri: Uri): Flowable<AmityUploadResult<AmityImage>> {
        return FileRepository().uploadImage(uploadId, uri)
    }
    
    /* begin_public_function
	  id: file.upload.audio
	  api_style: async
	*/
    fun uploadAudio(uri: Uri):Flowable<AmityUploadResult<AmityAudio>> {
        return uploadAudio(UUID.randomUUID().toString(), uri)
    }
    /* end_public_function */

    fun uploadAudio(uploadId: String, uri: Uri):Flowable<AmityUploadResult<AmityAudio>> {
        return FileRepository().uploadAudio(uploadId, uri)
    }
    
    /* begin_public_function
	  id: file.upload.video
	  api_style: async
	*/
    fun uploadVideo(uri: Uri, contentFeedType: AmityContentFeedType): Flowable<AmityUploadResult<AmityVideo>> {
        return uploadVideo(UUID.randomUUID().toString(), uri, contentFeedType)
    }
    /* end_public_function */

    fun uploadVideo(uploadId: String,
                    uri: Uri,
                    contentFeedType: AmityContentFeedType): Flowable<AmityUploadResult<AmityVideo>> {
        return FileRepository().uploadVideo(uploadId, uri, contentFeedType)
    }

    fun cancelUpload(uploadId: String) {
        FileRepository().cancelUpload(uploadId)
    }

    fun getUploadInfo(uploadId: String): Flowable<AmityUploadInfo> {
        return FileRepository().getUploadInfo(uploadId)
    }

    /* begin_public_function
	  id: file.delete
	  api_style: async
	*/
    fun deleteFile(fileId: String) : Completable {
        return FileDeleteUseCase().execute(fileId)
    }
    /* end_public_function */

    fun getFile(fileId: String): Single<AmityRawFile> {
        return RawFileGetUseCase().execute(fileId)
    }

}