package com.amity.socialcloud.sdk.api.chat.message.update

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject

class AmityTextMessageUpdate internal constructor(
    messageId: String,
    private val text: String?,
    private val tags: AmityTags?,
    private val metadata: JsonObject?,
    private val mentionees: List<AmityMentioneeTarget>?
) : AmityMessageUpdate(messageId) {

    override fun getData(): JsonObject? {
        return text?.let {
            JsonObject().apply {
                addProperty("text", text)
            }
        }
    }

    override fun getTags(): AmityTags? {
        return tags
    }

    override fun getMetadata(): JsonObject? {
        return metadata
    }

    override fun getMentionees(): List<AmityMentioneeTarget>? {
        return mentionees
    }

    class Builder internal constructor(private val messageId: String) {

        private var text: String? = null
        private var tags: AmityTags? = null
        private var metadata: JsonObject? = null
        private var mentionees: MutableList<AmityMentioneeTarget>? = null

        fun text(text: String): Builder {
            return apply { this.text = text }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            if (mentionees == null) {
                mentionees = mutableListOf()
            }
            mentionees?.add(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun mentionChannel(): Builder {
            if (mentionees == null) {
                mentionees = mutableListOf()
            }
            mentionees?.add(AmityMentioneeTarget(AmityMentionType.CHANNEL.apiKey))
            return this
        }

        fun build(): AmityTextMessageUpdate {
            return AmityTextMessageUpdate(messageId, text, tags, metadata, mentionees)
        }

    }
}