package com.amity.socialcloud.sdk.social.data.comment

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto
import com.ekoapp.ekosdk.internal.entity.CommentEntity

internal class CommentEntityMapper : EntityMapper<EkoCommentDto, CommentEntity>() {

    override fun map(list: List<EkoCommentDto>): List<CommentEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoCommentDto): CommentEntity {
        return CommentEntity().apply {
            commentId = dto.commentId
            path = dto.path
            referenceType = dto.referenceType
            referenceId = dto.referenceId
            userId = dto.userId
            parentId = dto.parentId
            rootId = dto.rootId
            dataType = dto.dataType
            data = dto.getData()
            metadata = dto.getMetadata()
            childrenNumber = dto.childrenNumber
            flagCount = dto.flagCount
            reactionCount = dto.reactionCount
            reactions = dto.reactions
            isDeleted = dto.deleted
            editedAt = dto.editedAt
            dataTypes = dto.dataTypes
            attachments = dto.attachments
            segmentNumber = dto.segmentNumber
            targetType = dto.targetType
            targetId = dto.targetId
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
            if (dto.mentionees != null) {
                mentionees = dto.mentionees
            }
        }
    }

}