package com.amity.socialcloud.sdk.entity.social.story

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime


@Entity(tableName = "story")
open class StoryEntity : EkoObject() {

    @PrimaryKey
    var uniqueId: String = "LOCAL" + ObjectId.get().toHexString()
    var storyId: String = ObjectId.get().toHexString()
    var path: String = ""
    var dataType: String = ""
    var data: JsonObject? = null
    var metadata: JsonObject? = null
    var items: JsonArray? = null
    var reactions: AmityReactionMap = AmityReactionMap()
    var reactionCount = 0
    var commentCount = 0
    var flagCount = 0
    var storyExpiresAt: DateTime? = null
    var isDeleted: Boolean = false
    var targetType: String = ""
    var targetId: String = ""
    var creatorId: String = ""
    var impression = 0
    var reach = 0

    // local properties
    var syncState: String = AmityStory.State.SYNCED.apiKey

    override fun getId(): String {
        return uniqueId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is StoryEntity
                && Objects.equal(storyId, other.storyId)
                && Objects.equal(uniqueId, other.uniqueId)
                && Objects.equal(path, other.path)
                && Objects.equal(metadata, other.metadata)
                && Objects.equal(reactions, other.reactions)
                && Objects.equal(reactionCount, other.reactionCount)
                && Objects.equal(commentCount, other.commentCount)
                && Objects.equal(flagCount, other.flagCount)
                && Objects.equal(items, other.items)
                && Objects.equal(storyExpiresAt, other.storyExpiresAt)
                && Objects.equal(isDeleted, other.isDeleted)
                && Objects.equal(targetType, other.targetType)
                && Objects.equal(targetId, other.targetId)
                && Objects.equal(data, other.data)
                && Objects.equal(impression, other.impression)
                && Objects.equal(reach, other.reach)
                && Objects.equal(syncState, other.syncState))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            storyId,
            uniqueId,
            path,
            metadata,
            reactions,
            reactionCount,
            commentCount,
            flagCount,
            items,
            storyExpiresAt,
            isDeleted,
            targetType,
            targetId,
            data,
            impression,
            reach,
            syncState
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("storyId", storyId)
            add("uniqueId", uniqueId)
            add("path", path)
            add("metadata", metadata)
            add("reactions", reactions)
            add("reactionCount", reactionCount)
            add("commentCount", commentCount)
            add("flagCount", flagCount)
            add("items", items)
            add("expiresAt", storyExpiresAt)
            add("isDeleted", isDeleted)
            add("targetType", targetType)
            add("targetId", targetId)
            add("data", data)
            add("impression", impression)
            add("reach", reach)
            add("syncState", syncState)
        }
        return super.internalToString(toStringHelper)
    }

}