package com.amity.socialcloud.sdk.chat.domain.marker.message

import com.amity.socialcloud.sdk.chat.data.message.MarkedMessageEventPersister
import com.ekoapp.ekosdk.internal.api.dto.MarkedMessageDto
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class SyncMarkedMessageUseCase {
	
	fun execute(dto: MarkedMessageDto): Completable {
		return MarkedMessageEventPersister().persist(dto)
				.subscribeOn(Schedulers.io())
	}
}