package com.amity.socialcloud.sdk.api.core.ads

import com.amity.socialcloud.sdk.core.domain.ad.markclick.MarkAdAsClickUseCase
import com.amity.socialcloud.sdk.core.domain.ad.markseen.MarkAdAsViewedUseCase
import com.amity.socialcloud.sdk.model.core.ad.AmityAd
import com.amity.socialcloud.sdk.model.core.ad.AmityAdPlacement
import com.amity.socialcloud.sdk.social.domain.story.markclicked.MarkStoryAsClickedUseCase
import com.amity.socialcloud.sdk.social.domain.story.markseen.MarkStoryAsViewedUseCase

class AmityAdAnalytics internal constructor(private val ad: AmityAd) {

    fun markAsSeen(adPlacement: AmityAdPlacement) {
        MarkAdAsViewedUseCase().execute(ad, adPlacement)
    }

    fun markLinkAsClicked(adPlacement: AmityAdPlacement) {
        MarkAdAsClickUseCase().execute(ad, adPlacement)
    }

}