package com.ekoapp.ekosdk.internal.api.dto

import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.ekoapp.ekosdk.EkoFlag
import com.google.gson.JsonArray
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName
import org.joda.time.DateTime

class EkoCommentDto constructor(
	@SerializedName("commentId")
	val commentId: String,
	
	@SerializedName("_id")
	val mid: String,
	
	@SerializedName("referenceType")
	val referenceType: String,
	
	@SerializedName("referenceId")
	val referenceId: String,
	
	@SerializedName("userId")
	val userId: String,
	
	@SerializedName("parentId")
	var parentId: String? = null,
	
	@SerializedName("rootId")
	val rootId: String? = null,
	
	@SerializedName("dataType")
	val dataType: String,

	@SerializedName("dataTypes")
	var dataTypes: List<String>,
	
	@SerializedName("targetType")
	var targetType: String,
	
	@SerializedName("targetId")
	var targetId: String,
	
	@JvmField
	@SerializedName("attachments")
	val attachments: JsonArray,
	
	@SerializedName("childrenNumber")
	val childrenNumber: Int = 0,
	
	@JvmField
	@SerializedName("data")
	var data: JsonElement? = null,
	
	@SerializedName("metadata")
	private var metadataElement: JsonElement? = null,
	
	@SerializedName("flagCount")
	val flagCount: Int = 0,
	
	@SerializedName("hashFlag")
	val flag: EkoFlag? = null,
	
	@SerializedName("reactions")
	val reactions: AmityReactionMap,
	
	@SerializedName("reactionsCount")
	val reactionCount: Int = 0,
	
	@SerializedName("myReactions")
	val myReactions: List<String>? = null,
	
	@SerializedName("isDeleted")
	val deleted: Boolean,
	
	@SerializedName("editedAt")
	val editedAt: DateTime,
	
	@SerializedName("children")
	val children: List<String>? = null,
	
	@SerializedName("mentionees")
	var mentionees: List<EkoMentioneesDto>,
	
	@SerializedName("path")
	val path: String,
	
	@SerializedName("segmentNumber")
	val segmentNumber: Int = 0
) : EkoObjectDto() {
	
	
	fun getData(): JsonObject? {
		return data?.let { if (it.isJsonObject) it.asJsonObject else null }
	}
	
	fun setData(data: JsonObject) {
		this.data = data
	}
	
	fun getMetadata(): JsonObject? {
		return metadataElement?.let { if (it.isJsonObject) it.asJsonObject else null }
	}
	
	fun setMetadata(metadata: JsonObject) {
		this.metadataElement = metadata
	}
	
	fun getAttachments(): JsonArray? {
		return if (attachments != null && attachments.isJsonArray) {
			attachments.asJsonArray
		} else null
	}
	
}