package com.amity.socialcloud.sdk.core.data.topic

import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient
import com.amity.socialcloud.sdk.model.core.events.AmityTopic
import io.reactivex.rxjava3.core.Completable

internal class TopicRepository {

    fun subscribe(topic: AmityTopic) : Completable {
       return AmityMqttClient.subscribe(topic)
    }

    fun unsubscribe(topic: AmityTopic) : Completable {
        return AmityMqttClient.unsubscribe(topic)
    }

}