package com.amity.socialcloud.sdk.chat.data.marker.reader

import com.ekoapp.ekosdk.internal.api.dto.MarkerSyncDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkingDto
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.POST
import retrofit2.http.PUT
import retrofit2.http.Path

interface MessageReaderApi {
	
	@POST("api/v1/markers/message-feeds/{messageFeedId}/start-reading")
	fun startSubChannelReading(
		@Path("messageFeedId") subChannelId: String
	): Single<SubChannelMarkingDto>
	
	@POST("api/v1/markers/message-feeds/reading")
	fun readSubChannel(
		@Body request: ReadSubChannelRequest
	): Single<SubChannelMarkingDto>
	
	@POST("api/v1/markers/message-feeds/{messageFeedId}/stop-reading")
	fun stopSubChannelReading(
		@Path("messageFeedId") subChannelId: String
	): Single<SubChannelMarkingDto>
	
	@PUT("api/v1/markers/message-feeds/{messageFeedId}/mark-delivering")
	fun markMessageDelivered(
		@Path("messageFeedId") subChannelId: String,
		@Body request: MarkMessageDeliveredRequest
	): Single<SubChannelMarkingDto>
	
	@PUT("/api/v1/markers/message-feeds/{messageFeedId}/mark-read")
	fun markMessageRead(
		@Path("messageFeedId") subChannelId: String,
		@Body request: MarkMessageReadRequest
	): Single<JsonObject>
	
}