/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.MentioneesConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class PostDao_Impl
extends PostDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PostEntity> __insertionAdapterOfPostEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final MentioneesConverter __mentioneesConverter = new MentioneesConverter();
    private final EntityDeletionOrUpdateAdapter<PostEntity> __deletionAdapterOfPostEntity;
    private final EntityDeletionOrUpdateAdapter<PostEntity> __updateAdapterOfPostEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfIncrementCommentCount;
    private final SharedSQLiteStatement __preparedStmtOfDecrementCommentCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePost;
    private final SharedSQLiteStatement __preparedStmtOfUpdateDeletedImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFeedTypeImpl;

    public PostDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPostEntity = new EntityInsertionAdapter<PostEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `post` (`postId`,`path`,`parentPostId`,`postedUserId`,`sharedUserId`,`metadata`,`sharedCount`,`reactions`,`reactionCount`,`commentCount`,`flagCount`,`editedAt`,`isDeleted`,`targetType`,`targetId`,`postDataType`,`data`,`childPostIds`,`feedType`,`mentionees`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPath());
                }
                if (value.getParentPostId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getParentPostId());
                }
                if (value.getPostedUserId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPostedUserId());
                }
                if (value.getSharedUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSharedUserId());
                }
                String _tmp = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                stmt.bindLong(7, (long)value.getSharedCount());
                String _tmp_1 = PostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
                stmt.bindLong(9, (long)value.getReactionCount());
                stmt.bindLong(10, (long)value.getCommentCount());
                stmt.bindLong(11, (long)value.getFlagCount());
                String _tmp_2 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_2);
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_3);
                if (value.getTargetType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getTargetId());
                }
                if (value.getPostDataType() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getPostDataType());
                }
                String _tmp_4 = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_4);
                }
                String _tmp_5 = PostDao_Impl.this.__stringListConverter.stringListToString(value.getChildPostIds());
                if (_tmp_5 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_5);
                }
                if (value.getFeedType() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getFeedType());
                }
                String _tmp_6 = PostDao_Impl.this.__mentioneesConverter.mentioneesToJson(value.getMentionees());
                if (_tmp_6 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_6);
                }
                String _tmp_7 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_7);
                }
                String _tmp_8 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_8);
                }
                String _tmp_9 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_9);
                }
            }
        };
        this.__deletionAdapterOfPostEntity = new EntityDeletionOrUpdateAdapter<PostEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `post` WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
            }
        };
        this.__updateAdapterOfPostEntity = new EntityDeletionOrUpdateAdapter<PostEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `post` SET `postId` = ?,`path` = ?,`parentPostId` = ?,`postedUserId` = ?,`sharedUserId` = ?,`metadata` = ?,`sharedCount` = ?,`reactions` = ?,`reactionCount` = ?,`commentCount` = ?,`flagCount` = ?,`editedAt` = ?,`isDeleted` = ?,`targetType` = ?,`targetId` = ?,`postDataType` = ?,`data` = ?,`childPostIds` = ?,`feedType` = ?,`mentionees` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPath());
                }
                if (value.getParentPostId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getParentPostId());
                }
                if (value.getPostedUserId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPostedUserId());
                }
                if (value.getSharedUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSharedUserId());
                }
                String _tmp = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                stmt.bindLong(7, (long)value.getSharedCount());
                String _tmp_1 = PostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
                stmt.bindLong(9, (long)value.getReactionCount());
                stmt.bindLong(10, (long)value.getCommentCount());
                stmt.bindLong(11, (long)value.getFlagCount());
                String _tmp_2 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_2);
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_3);
                if (value.getTargetType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getTargetId());
                }
                if (value.getPostDataType() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getPostDataType());
                }
                String _tmp_4 = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_4);
                }
                String _tmp_5 = PostDao_Impl.this.__stringListConverter.stringListToString(value.getChildPostIds());
                if (_tmp_5 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_5);
                }
                if (value.getFeedType() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getFeedType());
                }
                String _tmp_6 = PostDao_Impl.this.__mentioneesConverter.mentioneesToJson(value.getMentionees());
                if (_tmp_6 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_6);
                }
                String _tmp_7 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_7);
                }
                String _tmp_8 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_8);
                }
                String _tmp_9 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_9);
                }
                if (value.getPostId() == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, value.getPostId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from post";
                return "DELETE from post";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from post where parentPostId = ? or postId = ?";
                return "DELETE from post where parentPostId = ? or postId = ?";
            }
        };
        this.__preparedStmtOfIncrementCommentCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set commentCount = commentCount + 1 where postId = ?";
                return "UPDATE post set commentCount = commentCount + 1 where postId = ?";
            }
        };
        this.__preparedStmtOfDecrementCommentCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set commentCount = commentCount - 1 where postId = ?";
                return "UPDATE post set commentCount = commentCount - 1 where postId = ?";
            }
        };
        this.__preparedStmtOfUpdatePost = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set postId = postId where postId = ?";
                return "UPDATE post set postId = postId where postId = ?";
            }
        };
        this.__preparedStmtOfUpdateDeletedImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post SET isDeleted = ? WHERE postId LIKE ? ";
                return "UPDATE post SET isDeleted = ? WHERE postId LIKE ? ";
            }
        };
        this.__preparedStmtOfUpdateFeedTypeImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post SET feedType = ? WHERE postId = ? ";
                return "UPDATE post SET feedType = ? WHERE postId = ? ";
            }
        };
    }

    @Override
    public void insertImpl(PostEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPostEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends PostEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPostEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends PostEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPostEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(PostEntity ekoPost) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPostEntity.handle((Object)ekoPost);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(PostEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPostEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(PostEntity object) {
        this.__db.beginTransaction();
        try {
            PostDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends PostEntity> objects) {
        this.__db.beginTransaction();
        try {
            PostDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PostEntity object) {
        this.__db.beginTransaction();
        try {
            PostDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Completable deleteById(final String postId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = PostDao_Impl.this.__preparedStmtOfDeleteById.acquire();
                int _argIndex = 1;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, postId);
                }
                _argIndex = 2;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, postId);
                }
                PostDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PostDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    PostDao_Impl.this.__db.endTransaction();
                    PostDao_Impl.this.__preparedStmtOfDeleteById.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementCommentCount(String postId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrementCommentCount.acquire();
        int _argIndex = 1;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfIncrementCommentCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementCommentCount(String postId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDecrementCommentCount.acquire();
        int _argIndex = 1;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDecrementCommentCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePost(String postId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePost.acquire();
        int _argIndex = 1;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePost.release(_stmt);
        }
    }

    @Override
    Completable updateDeletedImpl(final String postId, final boolean isDeleted) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = PostDao_Impl.this.__preparedStmtOfUpdateDeletedImpl.acquire();
                int _argIndex = 1;
                int _tmp = isDeleted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, postId);
                }
                PostDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PostDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    PostDao_Impl.this.__db.endTransaction();
                    PostDao_Impl.this.__preparedStmtOfUpdateDeletedImpl.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateFeedTypeImpl(String postId, String feedType) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateFeedTypeImpl.acquire();
        int _argIndex = 1;
        if (feedType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, feedType);
        }
        _argIndex = 2;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateFeedTypeImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<PostEntity> getByIdsNowImpl(List<String> postIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from post where post.postId IN (");
        int _inputSize = postIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : postIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
            int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
            int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
            int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<PostEntity> _result = new ArrayList<PostEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                PostEntity _item_1 = new PostEntity();
                String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                _item_1.setPostId(_tmpPostId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item_1.setPath(_tmpPath);
                String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                _item_1.setParentPostId(_tmpParentPostId);
                String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                _item_1.setPostedUserId(_tmpPostedUserId);
                String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                _item_1.setSharedUserId(_tmpSharedUserId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setMetadata(_tmpMetadata);
                int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                _item_1.setSharedCount(_tmpSharedCount);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                _item_1.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item_1.setReactionCount(_tmpReactionCount);
                int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                _item_1.setCommentCount(_tmpCommentCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item_1.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setEditedAt(_tmpEditedAt);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_3 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _item_1.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _item_1.setTargetId(_tmpTargetId);
                String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                _item_1.setPostDataType(_tmpPostDataType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item_1.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                _item_1.setChildPostIds(_tmpChildPostIds);
                String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                _item_1.setFeedType(_tmpFeedType);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _item_1.setMentionees(_tmpMentionees);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<PostEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PostEntity getByIdNowImpl(String postIds) {
        String _sql = "SELECT * from post where post.postId IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post where post.postId IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postIds == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postIds);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PostEntity _result;
            int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
            int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
            int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
            int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new PostEntity();
                String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                _result.setPostId(_tmpPostId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                _result.setParentPostId(_tmpParentPostId);
                String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                _result.setPostedUserId(_tmpPostedUserId);
                String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                _result.setSharedUserId(_tmpSharedUserId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                _result.setSharedCount(_tmpSharedCount);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                _result.setCommentCount(_tmpCommentCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setEditedAt(_tmpEditedAt);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_3 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                _result.setPostDataType(_tmpPostDataType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _result.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                _result.setChildPostIds(_tmpChildPostIds);
                String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                _result.setFeedType(_tmpFeedType);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                _result.setMentionees(_tmpMentionees);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            PostEntity postEntity = _result;
            return postEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<PostEntity> getLatestChildrenPostImpl(String targetId, String targetType, List<String> postTypes, int hash, int nonce, DateTime now, Boolean includeDeleted, String feedType) {
        Integer _tmp_1;
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from post, amity_paging_id where post.targetType = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and post.targetId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  and post.isDeleted = (case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then post.isDeleted else ");
        _stringBuilder.append("?");
        _stringBuilder.append(" end) and post.feedType = (case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then post.feedType else ");
        _stringBuilder.append("?");
        _stringBuilder.append(" end) and post.postDataType in (");
        int _inputSize = postTypes.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")  and post.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by post.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 9 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        _argIndex = 3;
        Integer n = includeDeleted == null ? null : (_tmp = Integer.valueOf(includeDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = includeDeleted == null ? null : (_tmp_1 = Integer.valueOf(includeDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 6;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 7;
        for (String _item : postTypes) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 7 + _inputSize;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 8 + _inputSize;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 9 + _inputSize;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post", "amity_paging_id"}, (Callable)new Callable<PostEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PostEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PostEntity _result;
                    int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
                    int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
                    int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
                    int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new PostEntity();
                        String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                        _result.setPostId(_tmpPostId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                        _result.setParentPostId(_tmpParentPostId);
                        String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                        _result.setPostedUserId(_tmpPostedUserId);
                        String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                        _result.setSharedUserId(_tmpSharedUserId);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        _result.setMetadata(_tmpMetadata);
                        int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                        _result.setSharedCount(_tmpSharedCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _result.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_6 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                        _result.setPostDataType(_tmpPostDataType);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                        _result.setData(_tmpData);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                        List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_8);
                        _result.setChildPostIds(_tmpChildPostIds);
                        String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                        _result.setFeedType(_tmpFeedType);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = PostDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_9);
                        _result.setMentionees(_tmpMentionees);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    PostEntity postEntity = _result;
                    return postEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<PostEntity> getLatestParentPostImpl(String targetId, String targetType, int hash, int nonce, DateTime now, Boolean includeDeleted, String feedType) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from post where post.targetType = ? and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and post.feedType = (case when ? is null then post.feedType else ? end) and post.updatedAt > ? and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by post.updatedAt  desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post where post.targetType = ? and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and post.feedType = (case when ? is null then post.feedType else ? end) and post.updatedAt > ? and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by post.updatedAt  desc limit 1", (int)9);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        _argIndex = 3;
        Integer n = includeDeleted == null ? null : (_tmp = Integer.valueOf(includeDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = includeDeleted == null ? null : (_tmp_1 = Integer.valueOf(includeDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 6;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 7;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 8;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 9;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post", "amity_paging_id"}, (Callable)new Callable<PostEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PostEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PostEntity _result;
                    int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
                    int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
                    int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
                    int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new PostEntity();
                        String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                        _result.setPostId(_tmpPostId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                        _result.setParentPostId(_tmpParentPostId);
                        String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                        _result.setPostedUserId(_tmpPostedUserId);
                        String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                        _result.setSharedUserId(_tmpSharedUserId);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        _result.setMetadata(_tmpMetadata);
                        int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                        _result.setSharedCount(_tmpSharedCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _result.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_6 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                        _result.setPostDataType(_tmpPostDataType);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                        _result.setData(_tmpData);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                        List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_8);
                        _result.setChildPostIds(_tmpChildPostIds);
                        String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                        _result.setFeedType(_tmpFeedType);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = PostDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_9);
                        _result.setMentionees(_tmpMentionees);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    PostEntity postEntity = _result;
                    return postEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<PostEntity> getPostImpl(String postIds) {
        String _sql = "SELECT * from post where post.postId IN (?) LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post where post.postId IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postIds == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postIds);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post"}, (Callable)new Callable<PostEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PostEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PostEntity _result;
                    int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
                    int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
                    int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
                    int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new PostEntity();
                        String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                        _result.setPostId(_tmpPostId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                        _result.setParentPostId(_tmpParentPostId);
                        String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                        _result.setPostedUserId(_tmpPostedUserId);
                        String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                        _result.setSharedUserId(_tmpSharedUserId);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setMetadata(_tmpMetadata);
                        int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                        _result.setSharedCount(_tmpSharedCount);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _result.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_3 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                        _result.setPostDataType(_tmpPostDataType);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setData(_tmpData);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                        List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_5);
                        _result.setChildPostIds(_tmpChildPostIds);
                        String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                        _result.setFeedType(_tmpFeedType);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = PostDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                        _result.setMentionees(_tmpMentionees);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    PostEntity postEntity = _result;
                    return postEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<PostEntity>> observePostImpl(String postId) {
        String _sql = "SELECT * from post where post.postId IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post where post.postId IN (?)", (int)1);
        int _argIndex = 1;
        if (postId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post"}, (Callable)new Callable<List<PostEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PostEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
                    int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
                    int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
                    int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<PostEntity> _result = new ArrayList<PostEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PostEntity _item = new PostEntity();
                        String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                        _item.setPostId(_tmpPostId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _item.setPath(_tmpPath);
                        String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                        _item.setParentPostId(_tmpParentPostId);
                        String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                        _item.setPostedUserId(_tmpPostedUserId);
                        String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                        _item.setSharedUserId(_tmpSharedUserId);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _item.setMetadata(_tmpMetadata);
                        int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                        _item.setSharedCount(_tmpSharedCount);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                        _item.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _item.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _item.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _item.setFlagCount(_tmpFlagCount);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item.setEditedAt(_tmpEditedAt);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_3 != 0;
                        _item.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _item.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _item.setTargetId(_tmpTargetId);
                        String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                        _item.setPostDataType(_tmpPostDataType);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _item.setData(_tmpData);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                        List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_5);
                        _item.setChildPostIds(_tmpChildPostIds);
                        String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                        _item.setFeedType(_tmpFeedType);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = PostDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                        _item.setMentionees(_tmpMentionees);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    ArrayList<PostEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

