/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.comment;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentDataTypeFilter;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentSortOption;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.data.comment.CommentLocalDataStore;
import com.amity.socialcloud.sdk.social.data.comment.CommentModelMapper;
import com.amity.socialcloud.sdk.social.data.comment.CommentQueryPersister;
import com.amity.socialcloud.sdk.social.data.comment.CommentRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.api.socket.request.CommentQueryRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoQueryToken;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult;
import com.ekoapp.ekosdk.internal.repository.comment.CommentMediator;
import com.google.common.base.Objects;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.amity.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jl\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eJh\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJB\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0007J(\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\"\u001a\u00020#JU\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050%0 2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#2\b\u0010(\u001a\u0004\u0018\u00010)\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020,H\u0002J$\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001bJE\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020,\u00a2\u0006\u0002\u00101J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J$\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J \u00104\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eH\u0002J \u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u0007H\u0002J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\n\u001a\u00020\u0007JE\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010>\u001a\u00020\u0007\u00a2\u0006\u0002\u0010?JM\u0010@\u001a\b\u0012\u0004\u0012\u00020=0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010A\u001a\u00020,\u00a2\u0006\u0002\u0010BJ\u000e\u0010C\u001a\u0002072\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010D\u001a\u0002072\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\n\u001a\u00020\u0007JF\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\b\u0010G\u001a\u0004\u0018\u00010\u0007J\u000e\u0010H\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0007J\u0018\u0010I\u001a\u0002072\u0006\u00108\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u0007H\u0002\u00a8\u0006J"}, d2={"Lcom/amity/socialcloud/sdk/social/data/comment/CommentRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createComment", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "referenceType", "", "referenceId", "parentId", "commentId", "data", "Lcom/google/gson/JsonObject;", "dataTypes", "", "attachments", "Lcom/google/gson/JsonArray;", "metadata", "mentionees", "Lcom/amity/socialcloud/sdk/model/core/mention/AmityMentioneeTarget;", "createTempComment", "Lcom/ekoapp/ekosdk/internal/entity/CommentEntity;", "createTempFlag", "Lcom/ekoapp/ekosdk/internal/data/model/EkoCommentFlagEntity;", "deleteComment", "Lio/reactivex/rxjava3/core/Completable;", "hardDelete", "", "editComment", "flagComment", "getComment", "getCommentCollection", "Lio/reactivex/rxjava3/core/Flowable;", "ids", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;", "getCommentPagingData", "Landroidx/paging/PagingData;", "isFilterByParentId", "isDeleted", "dataTypeFilter", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentDataTypeFilter;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentDataTypeFilter;)Lio/reactivex/rxjava3/core/Flowable;", "getDefaultPageSize", "", "getLatestComment", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getLatestComments", "getLatestReplies", "getMentioneesDto", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoMentioneesDto;", "insertOrUpdate", "", "comment", "commentFlag", "syncState", "isFlaggedByMe", "loadComments", "Lcom/ekoapp/ekosdk/internal/repository/comment/CommentLoadResult;", "token", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "loadFirstPageComments", "limit", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;I)Lio/reactivex/rxjava3/core/Single;", "markDeletedAfterCommentId", "markDeletedBeforeCommentId", "observeComment", "observeCommentAfter", "offsetCommentId", "unflagComment", "updateSyncState", "amity-sdk_release"})
public final class CommentRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @Nullable
    public final AmityComment getComment(@NotNull String commentId) {
        AmityComment amityComment;
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        CommentEntity commentEntity = new CommentLocalDataStore().getComment(commentId);
        if (commentEntity != null) {
            CommentEntity it = commentEntity;
            boolean bl = false;
            amityComment = new CommentModelMapper().map(it);
        } else {
            amityComment = null;
        }
        return amityComment;
    }

    @NotNull
    public final List<AmityComment> getLatestComments(@NotNull String referenceType, @NotNull String referenceId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        return new CommentLocalDataStore().getLatestComments(referenceType, referenceId);
    }

    @NotNull
    public final List<AmityComment> getLatestReplies(@NotNull String referenceType, @NotNull String referenceId, @NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        return new CommentLocalDataStore().getLatestReplies(referenceType, referenceId, parentId);
    }

    @NotNull
    public final Flowable<AmityComment> observeComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Flowable flowable = new CommentLocalDataStore().observeComment(commentId).map(CommentRepository::observeComment$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Single<AmityComment> createComment(@NotNull String referenceType, @NotNull String referenceId, @Nullable String parentId, @Nullable String commentId, @Nullable JsonObject data, @NotNull List<String> dataTypes, @Nullable JsonArray attachments, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        CommentEntity localComment = this.createTempComment(referenceType, referenceId, parentId, commentId, data, dataTypes, attachments, metadata, mentionees);
        EkoCommentFlagEntity commentFlag = this.createTempFlag(localComment.getCommentId());
        Single single = Single.fromCallable(() -> CommentRepository.createComment$lambda-2(this, localComment, commentFlag)).flatMap(arg_0 -> CommentRepository.createComment$lambda-3(localComment, referenceType, referenceId, parentId, data, attachments, metadata, mentionees, arg_0)).onErrorResumeNext(arg_0 -> CommentRepository.createComment$lambda-4(this, localComment, arg_0)).flatMap(CommentRepository::createComment$lambda-5).map(arg_0 -> CommentRepository.createComment$lambda-8(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromCallable {\n         \u2026        comment\n        }");
        return single;
    }

    @NotNull
    public final Single<AmityComment> editComment(@NotNull String commentId, @Nullable JsonObject data, @Nullable JsonArray attachments, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Single single = new CommentRemoteDataStore().updateComment(commentId, data, attachments, metadata, mentionees).flatMap(CommentRepository::editComment$lambda-9).map(arg_0 -> CommentRepository.editComment$lambda-12(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommentRemoteDataStore()\u2026    comment\n            }");
        return single;
    }

    @NotNull
    public final Completable deleteComment(@NotNull String commentId, boolean hardDelete) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Completable completable = new CommentLocalDataStore().observeComment(commentId).firstOrError().subscribeOn(Schedulers.io()).flatMapCompletable(arg_0 -> CommentRepository.deleteComment$lambda-14(commentId, hardDelete, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommentLocalDataStore().\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Flowable<PagingData<AmityComment>> getCommentPagingData(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortOption, @Nullable AmityCommentDataTypeFilter dataTypeFilter) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new CommentMediator(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption, dataTypeFilter), (Function0)new Function0<PagingSource<Integer, CommentEntity>>(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption, dataTypeFilter){
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $referenceType;
            final /* synthetic */ boolean $isFilterByParentId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ Boolean $isDeleted;
            final /* synthetic */ AmityCommentSortOption $sortOption;
            final /* synthetic */ AmityCommentDataTypeFilter $dataTypeFilter;
            {
                this.$referenceId = $referenceId;
                this.$referenceType = $referenceType;
                this.$isFilterByParentId = $isFilterByParentId;
                this.$parentId = $parentId;
                this.$isDeleted = $isDeleted;
                this.$sortOption = $sortOption;
                this.$dataTypeFilter = $dataTypeFilter;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, CommentEntity> invoke() {
                return new CommentLocalDataStore().getCommentPagingSource(this.$referenceId, this.$referenceType, this.$isFilterByParentId, this.$parentId, this.$isDeleted, this.$sortOption, this.$dataTypeFilter);
            }
        }, (ModelMapper)new CommentModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Single<AmityComment> getLatestComment(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        CommentQueryRequest.CommentQueryRequestOptions options = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, 1, null, "pagination", null, 175, null);
        CommentQueryRequest commentQueryRequest = new CommentQueryRequest(referenceId, referenceType, isFilterByParentId, null, false, AmityCommentSortOption.LAST_CREATED.getApiKey(), options, null, 136, null);
        Single single = new CommentRemoteDataStore().queryComments(commentQueryRequest).flatMap(CommentRepository::getLatestComment$lambda-15).flatMap(CommentRepository::getLatestComment$lambda-16);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommentRemoteDataStore()\u2026          }\n            }");
        return single;
    }

    @NotNull
    public final Flowable<List<AmityComment>> observeCommentAfter(@NotNull String referenceType, @NotNull String referenceId, @Nullable String parentId, boolean isFilterByParentId, @NotNull AmityCommentSortOption sortOption, @Nullable String offsetCommentId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = UserDatabase.get().commentDao().observeCommentAfter(referenceType, referenceId, parentId, isFilterByParentId, sortOption, offsetCommentId).map(CommentRepository::observeCommentAfter$lambda-18);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"get().commentDao().obser\u2026)\n            }\n        }");
        return flowable;
    }

    @NotNull
    public final Single<CommentLoadResult> loadComments(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull String token) {
        CommentQueryRequest.CommentQueryRequestOptions commentQueryRequestOptions;
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        CommentQueryRequest.CommentQueryRequestOptions $this$loadComments_u24lambda_u2d19 = commentQueryRequestOptions = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, null, null, null, null, 255, null);
        boolean bl = false;
        $this$loadComments_u24lambda_u2d19.setType("pagination");
        $this$loadComments_u24lambda_u2d19.setToken(token);
        CommentQueryRequest.CommentQueryRequestOptions options = commentQueryRequestOptions;
        CommentQueryRequest commentQueryRequest = new CommentQueryRequest(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, null, options, null, 160, null);
        Single single = new CommentRemoteDataStore().queryComments(commentQueryRequest).flatMap(CommentRepository::loadComments$lambda-20).map(CommentRepository::loadComments$lambda-22);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommentRemoteDataStore()\u2026nNext, ids)\n            }");
        return single;
    }

    @NotNull
    public final Single<CommentLoadResult> loadFirstPageComments(@NotNull String referenceType, @NotNull String referenceId, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortOption, int limit) {
        CommentQueryRequest.CommentQueryRequestOptions commentQueryRequestOptions;
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        CommentQueryRequest.CommentQueryRequestOptions $this$loadFirstPageComments_u24lambda_u2d23 = commentQueryRequestOptions = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, null, null, null, null, 255, null);
        boolean bl = false;
        $this$loadFirstPageComments_u24lambda_u2d23.setSkip(0);
        $this$loadFirstPageComments_u24lambda_u2d23.setLimit(limit);
        $this$loadFirstPageComments_u24lambda_u2d23.setType("pagination");
        CommentQueryRequest.CommentQueryRequestOptions options = commentQueryRequestOptions;
        CommentQueryRequest commentQueryRequest = new CommentQueryRequest(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption.getApiKey(), options, null, 128, null);
        Single single = new CommentRemoteDataStore().queryComments(commentQueryRequest).flatMap(CommentRepository::loadFirstPageComments$lambda-24).map(CommentRepository::loadFirstPageComments$lambda-26);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommentRemoteDataStore()\u2026token, ids)\n            }");
        return single;
    }

    public final void markDeletedAfterCommentId(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        new CommentLocalDataStore().markDeletedAfterCommentId(commentId);
    }

    public final void markDeletedBeforeCommentId(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        new CommentLocalDataStore().markDeletedBeforeCommentId(commentId);
    }

    @NotNull
    public final Flowable<List<AmityComment>> getCommentCollection(@NotNull List<String> ids, @NotNull AmityCommentSortOption sortOption) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = UserDatabase.get().commentDao().getAllByIds(ids, sortOption).map(CommentRepository::getCommentCollection$lambda-28);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"get().commentDao().getAl\u2026commentList\n            }");
        return flowable;
    }

    @NotNull
    public final Completable flagComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Completable completable = new CommentRemoteDataStore().flagComment(commentId).flatMapCompletable(CommentRepository::flagComment$lambda-29);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommentRemoteDataStore()\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable unflagComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Completable completable = new CommentRemoteDataStore().unflagComment(commentId).flatMapCompletable(CommentRepository::unflagComment$lambda-30);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommentRemoteDataStore()\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Single<JsonObject> isFlaggedByMe(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new CommentRemoteDataStore().isFlaggedByMe(commentId);
    }

    @NotNull
    public final Flowable<AmityComment> getLatestComment(@NotNull String referenceId, @NotNull String referenceType, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new CommentLocalDataStore().getLatestComment(referenceId, referenceType, parentId, isDeleted, dynamicQueryStreamKeyCreator, nonce).map(CommentRepository::getLatestComment$lambda-31);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentLocalDataStore()\n\u2026r().map(it)\n            }");
        return flowable;
    }

    private final CommentEntity createTempComment(String referenceType, String referenceId, String parentId, String commentId, JsonObject data, List<String> dataTypes, JsonArray attachments, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        CharSequence charSequence = commentId;
        String id = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ObjectId.get().toHexString() : commentId;
        DateTime now = new DateTime();
        String string = AmityCoreClient.INSTANCE.getUserId();
        String string2 = AmityComment.State.CREATED.getStateName();
        List list = this.getMentioneesDto(mentionees);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List list2 = list;
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
        CommentEntity comment = new CommentEntity(id, null, referenceType, referenceId, string, parentId, null, null, dataTypes, data, attachments, metadata, 0, 0, null, 0, false, now, string2, 0, list2, 651458, null);
        comment.setCreatedAt(now);
        comment.setUpdatedAt(now);
        return comment;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EkoMentioneesDto> getMentioneesDto(List<AmityMentioneeTarget> mentionees) {
        List list;
        List<AmityMentioneeTarget> list2 = mentionees;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AmityMentioneeTarget amityMentioneeTarget = (AmityMentioneeTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EkoMentioneesDto(it.getType(), it.getUserIds(), null, 4, null));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final EkoCommentFlagEntity createTempFlag(String commentId) {
        EkoCommentFlagEntity commentFlag = new EkoCommentFlagEntity(commentId, null, null, 6, null);
        return commentFlag;
    }

    private final void insertOrUpdate(CommentEntity comment, EkoCommentFlagEntity commentFlag, String syncState) {
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        EkoCommentFlagDao commentFlagDao = UserDatabase.get().commentFlagDao();
        commentDao.insert((EkoObject)comment);
        commentFlagDao.insert((EkoObject)commentFlag);
        this.updateSyncState(comment, syncState);
    }

    private final void updateSyncState(CommentEntity comment, String syncState) {
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        comment.setSyncState(syncState);
        commentDao.update((EkoObject)comment);
        comment.setSyncState(AmityComment.State.FAILED.getStateName());
        commentDao.update((EkoObject)comment);
    }

    private static final AmityComment observeComment$lambda-1(CommentEntity it) {
        CommentModelMapper commentModelMapper = new CommentModelMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return commentModelMapper.map(it);
    }

    private static final CommentEntity createComment$lambda-2(CommentRepository this$0, CommentEntity $localComment, EkoCommentFlagEntity $commentFlag) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$localComment, (String)"$localComment");
        Intrinsics.checkNotNullParameter((Object)$commentFlag, (String)"$commentFlag");
        this$0.insertOrUpdate($localComment, $commentFlag, AmityComment.State.SYNCING.getStateName());
        return $localComment;
    }

    private static final SingleSource createComment$lambda-3(CommentEntity $localComment, String $referenceType, String $referenceId, String $parentId, JsonObject $data, JsonArray $attachments, JsonObject $metadata, List $mentionees, CommentEntity it) {
        Intrinsics.checkNotNullParameter((Object)$localComment, (String)"$localComment");
        Intrinsics.checkNotNullParameter((Object)$referenceType, (String)"$referenceType");
        Intrinsics.checkNotNullParameter((Object)$referenceId, (String)"$referenceId");
        CommentRemoteDataStore commentRemoteDataStore = new CommentRemoteDataStore();
        String string = $localComment.getCommentId();
        return (SingleSource)commentRemoteDataStore.createComment($referenceType, $referenceId, $parentId, string, $data, $attachments, $metadata, $mentionees);
    }

    private static final SingleSource createComment$lambda-4(CommentRepository this$0, CommentEntity $localComment, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$localComment, (String)"$localComment");
        this$0.updateSyncState($localComment, AmityComment.State.FAILED.getStateName());
        return (SingleSource)Single.error((Throwable)it);
    }

    private static final SingleSource createComment$lambda-5(EkoCommentAndUserListDto it) {
        CommentQueryPersister commentQueryPersister = new CommentQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)commentQueryPersister.persist(it).andThen((SingleSource)Single.just((Object)it.getComments().get(0).getCommentId()));
    }

    private static final AmityComment createComment$lambda-8(CommentRepository this$0, String it) {
        AmityComment comment;
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            comment = this$0.getComment(it);
            Object object2 = comment;
            if (object2 != null && (object2 = ((AmityComment)object2).getReference()) != null) {
                Object reference = object2;
                boolean bl = false;
                PostLocalDataStore postLocalDataStore = new PostLocalDataStore();
                if (reference instanceof AmityComment.Reference.POST) {
                    postLocalDataStore.incrementCommentCount(((AmityComment.Reference.POST)reference).getPostId());
                    postLocalDataStore.notifyPost(((AmityComment.Reference.POST)reference).getPostId());
                } else if (reference instanceof AmityComment.Reference.CONTENT) {
                    postLocalDataStore.incrementCommentCount(((AmityComment.Reference.CONTENT)reference).getContentId());
                    postLocalDataStore.notifyPost(((AmityComment.Reference.CONTENT)reference).getContentId());
                }
            }
            if ((object = comment) == null || (object = ((AmityComment)object).getParentId()) == null) break block4;
            Object parentCommentId = object;
            boolean bl = false;
            CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
            commentLocalDataStore.notifyParentComment((String)parentCommentId);
        }
        return comment;
    }

    private static final SingleSource editComment$lambda-9(EkoCommentAndUserListDto it) {
        CommentQueryPersister commentQueryPersister = new CommentQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)commentQueryPersister.persist(it).andThen((SingleSource)Single.just((Object)it.getComments().get(0).getCommentId()));
    }

    private static final AmityComment editComment$lambda-12(CommentRepository this$0, String it) {
        AmityComment comment;
        block2: {
            Object object;
            Object it2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            comment = this$0.getComment(it);
            Object object2 = comment;
            if (object2 != null && (object2 = ((AmityComment)object2).getReference()) != null) {
                it2 = object2;
                boolean bl = false;
                if (it2 instanceof AmityComment.Reference.POST) {
                    PostLocalDataStore postLocalDataStore = new PostLocalDataStore();
                    postLocalDataStore.notifyPost(((AmityComment.Reference.POST)it2).getPostId());
                }
            }
            if ((object = comment) == null || (object = ((AmityComment)object).getParentId()) == null) break block2;
            it2 = object;
            boolean bl = false;
            CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
            commentLocalDataStore.notifyParentComment((String)it2);
        }
        return comment;
    }

    private static final CompletableSource deleteComment$lambda-14$lambda-13(String $commentId, boolean $hardDelete, EkoDeletionDto it) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)$commentId, (String)"$commentId");
        if (it.isSuccess()) {
            Completable completable;
            CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
            CommentEntity commentEntity = new CommentLocalDataStore().getComment($commentId);
            if (commentEntity != null) {
                if (Objects.equal((Object)commentEntity.getReferenceType(), (Object)"post")) {
                    new PostLocalDataStore().decrementCommentCount(commentEntity.getReferenceId());
                } else if (Objects.equal((Object)commentEntity.getReferenceType(), (Object)"content")) {
                    new PostLocalDataStore().decrementCommentCount(commentEntity.getReferenceId());
                }
                completable = $hardDelete ? commentLocalDataStore.hardDelete($commentId) : commentLocalDataStore.softDelete($commentId);
            } else {
                completable = Completable.complete();
            }
            completableSource = (CompletableSource)completable;
        } else {
            completableSource = (CompletableSource)Completable.complete();
        }
        return completableSource;
    }

    private static final CompletableSource deleteComment$lambda-14(String $commentId, boolean $hardDelete, CommentEntity localComment) {
        Intrinsics.checkNotNullParameter((Object)$commentId, (String)"$commentId");
        return Intrinsics.areEqual((Object)localComment.getSyncState(), (Object)AmityComment.State.FAILED.getStateName()) ? (CompletableSource)new CommentLocalDataStore().hardDelete(localComment.getCommentId()) : (CompletableSource)new CommentRemoteDataStore().deleteComment($commentId, $hardDelete).flatMapCompletable(arg_0 -> CommentRepository.deleteComment$lambda-14$lambda-13($commentId, $hardDelete, arg_0));
    }

    private static final SingleSource getLatestComment$lambda-15(EkoCommentAndUserListDto it) {
        CommentQueryPersister commentQueryPersister = new CommentQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)commentQueryPersister.persist(it).andThen((SingleSource)Single.just((Object)it));
    }

    private static final SingleSource getLatestComment$lambda-16(EkoCommentAndUserListDto it) {
        Single single;
        if (it.getComments().isEmpty()) {
            AmityException exception = AmityException.Companion.create("item not found", null, AmityError.ITEM_NOT_FOUND);
            single = Single.error((Throwable)exception);
        } else {
            List<EkoCommentDto> list = it.getComments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"it.comments");
            String commentId = ((EkoCommentDto)CollectionsKt.first(list)).getCommentId();
            CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
            Intrinsics.checkNotNullExpressionValue((Object)commentId, (String)"commentId");
            CommentEntity comment = commentLocalDataStore.getComment(commentId);
            if (comment == null) {
                AmityException exception = AmityException.Companion.create("item not found", null, AmityError.ITEM_NOT_FOUND);
                single = Single.error((Throwable)exception);
            } else {
                single = Single.just((Object)new CommentModelMapper().map(comment));
            }
        }
        return (SingleSource)single;
    }

    /*
     * WARNING - void declaration
     */
    private static final List observeCommentAfter$lambda-18(List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CommentEntity commentEntity = (CommentEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CommentModelMapper commentModelMapper = new CommentModelMapper();
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            collection.add(commentModelMapper.map((CommentEntity)it2));
        }
        return (List)destination$iv$iv;
    }

    private static final SingleSource loadComments$lambda-20(EkoCommentAndUserListDto it) {
        CommentQueryPersister commentQueryPersister = new CommentQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)commentQueryPersister.persist(it).andThen((SingleSource)Single.just((Object)it));
    }

    /*
     * WARNING - void declaration
     */
    private static final CommentLoadResult loadComments$lambda-22(EkoCommentAndUserListDto commentAndUserListDto) {
        void $this$mapTo$iv$iv;
        List<EkoCommentDto> list = commentAndUserListDto.getComments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"commentAndUserListDto.comments");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoCommentDto ekoCommentDto = (EkoCommentDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCommentId());
        }
        List ids = (List)destination$iv$iv;
        Object object = commentAndUserListDto.getToken();
        if (object == null || (object = ((EkoQueryToken)object).getNext()) == null) {
            object = "";
        }
        Object tokenNext = object;
        return new CommentLoadResult((String)tokenNext, ids);
    }

    private static final SingleSource loadFirstPageComments$lambda-24(EkoCommentAndUserListDto it) {
        CommentQueryPersister commentQueryPersister = new CommentQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)commentQueryPersister.persist(it).andThen((SingleSource)Single.just((Object)it));
    }

    /*
     * WARNING - void declaration
     */
    private static final CommentLoadResult loadFirstPageComments$lambda-26(EkoCommentAndUserListDto commentAndUserListDto) {
        void $this$mapTo$iv$iv;
        List<EkoCommentDto> list = commentAndUserListDto.getComments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"commentAndUserListDto.comments");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoCommentDto ekoCommentDto = (EkoCommentDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCommentId());
        }
        List ids = (List)destination$iv$iv;
        Object object = commentAndUserListDto.getToken();
        if (object == null || (object = ((EkoQueryToken)object).getNext()) == null) {
            object = "";
        }
        Object token = object;
        return new CommentLoadResult((String)token, ids);
    }

    private static final List getCommentCollection$lambda-28(List list) {
        List commentList = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommentEntity commentEntity = (CommentEntity)element$iv;
            boolean bl = false;
            CommentModelMapper commentModelMapper = new CommentModelMapper();
            Intrinsics.checkNotNullExpressionValue((Object)commentEntity, (String)"commentEntity");
            commentList.add(commentModelMapper.map(commentEntity));
        }
        return commentList;
    }

    private static final CompletableSource flagComment$lambda-29(EkoCommentAndUserListDto it) {
        CommentQueryPersister commentQueryPersister = new CommentQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)commentQueryPersister.persist(it);
    }

    private static final CompletableSource unflagComment$lambda-30(EkoCommentAndUserListDto it) {
        CommentQueryPersister commentQueryPersister = new CommentQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)commentQueryPersister.persist(it);
    }

    private static final AmityComment getLatestComment$lambda-31(CommentEntity it) {
        CommentModelMapper commentModelMapper = new CommentModelMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return commentModelMapper.map(it);
    }
}

