/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.follow;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus;
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bJ\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aJ\u0014\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0005J\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010$\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0005J\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0005\u00a8\u0006&"}, d2={"Lcom/amity/socialcloud/sdk/core/data/follow/FollowLocalDataStore;", "", "()V", "getBlockedPagingSource", "Landroidx/paging/PagingSource;", "", "Lcom/ekoapp/ekosdk/internal/data/model/EkoUserFollowStatusEntity;", "userId", "", "getFollowCount", "Lcom/ekoapp/ekosdk/internal/data/model/EkoFollowCountEntity;", "getFollowCountByIdNow", "getFollowersPagingSource", "filter", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityFollowStatusFilter;", "getFollowingsPagingSource", "getLatestFollower", "Lio/reactivex/rxjava3/core/Flowable;", "getLatestFollowing", "observeFollowCount", "observeUserFollow", "sourceUserId", "targetUserId", "saveFollow", "Lio/reactivex/rxjava3/core/Completable;", "follows", "", "saveFollowCount", "followCounts", "updateFollower", "", "status", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityFollowStatus;", "updateFollowerCount", "followerCount", "updateFollowing", "updateFollowingCount", "updatePendingCount", "amity-sdk_release"})
public final class FollowLocalDataStore {
    @NotNull
    public final Completable saveFollow(@NotNull List<EkoUserFollowStatusEntity> follows) {
        Intrinsics.checkNotNullParameter(follows, (String)"follows");
        Completable completable = Completable.fromAction(() -> FollowLocalDataStore.saveFollow$lambda-0(follows));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026).save(follows)\n        }");
        return completable;
    }

    @NotNull
    public final Completable saveFollowCount(@NotNull List<EkoFollowCountEntity> followCounts) {
        Intrinsics.checkNotNullParameter(followCounts, (String)"followCounts");
        Completable completable = Completable.fromAction(() -> FollowLocalDataStore.saveFollowCount$lambda-1(followCounts));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026e(followCounts)\n        }");
        return completable;
    }

    @Nullable
    public final EkoFollowCountEntity getFollowCount(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return UserDatabase.get().followCountDao().getByIdNow(userId);
    }

    @NotNull
    public final Flowable<EkoFollowCountEntity> observeFollowCount(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Flowable<EkoFollowCountEntity> flowable = UserDatabase.get().followCountDao().getById(userId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"get().followCountDao().getById(userId)");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> observeUserFollow(@NotNull String sourceUserId, @NotNull String targetUserId) {
        Intrinsics.checkNotNullParameter((Object)sourceUserId, (String)"sourceUserId");
        Intrinsics.checkNotNullParameter((Object)targetUserId, (String)"targetUserId");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getUserFollowById(sourceUserId, targetUserId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"get().followDao().getUse\u2026urceUserId, targetUserId)");
        return flowable;
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getFollowingsPagingSource(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        return UserDatabase.get().followingPagingDao().getFollowingPagingSource(userId, filter);
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getFollowersPagingSource(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        return UserDatabase.get().followingPagingDao().getFollowerPagingSource(userId, filter);
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> getLatestFollowing(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getLatestFollowing(userId, filter.getStatuses());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"get().followDao().getLat\u2026(userId, filter.statuses)");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> getLatestFollower(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getLatestFollower(userId, filter.getStatuses());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"get().followDao().getLat\u2026(userId, filter.statuses)");
        return flowable;
    }

    public final void updateFollower(@NotNull String userId, @NotNull AmityFollowStatus status) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        UserDatabase.get().followDao().updateFollower(userId, status.getApiKey());
    }

    public final void updateFollowing(@NotNull String userId, @NotNull AmityFollowStatus status) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        UserDatabase.get().followDao().updateFollowing(userId, status.getApiKey());
    }

    @NotNull
    public final EkoFollowCountEntity getFollowCountByIdNow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        EkoFollowCountEntity ekoFollowCountEntity = UserDatabase.get().followCountDao().getByIdNow(userId);
        Intrinsics.checkNotNull((Object)ekoFollowCountEntity);
        return ekoFollowCountEntity;
    }

    public final void updateFollowerCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updateFollowerCount(userId, followerCount);
    }

    public final void updatePendingCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updatePendingCount(userId, followerCount);
    }

    public final void updateFollowingCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updateFollowingCount(userId, followerCount);
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getBlockedPagingSource(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return UserDatabase.get().followingPagingDao().getBlockedPagingSource(userId);
    }

    private static final void saveFollow$lambda-0(List $follows) {
        Intrinsics.checkNotNullParameter((Object)$follows, (String)"$follows");
        UserDatabase.get().followDao().save($follows);
    }

    private static final void saveFollowCount$lambda-1(List $followCounts) {
        Intrinsics.checkNotNullParameter((Object)$followCounts, (String)"$followCounts");
        UserDatabase.get().followCountDao().save($followCounts);
    }
}

