/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.post;

import com.amity.socialcloud.sdk.api.social.AmitySocialClient;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentQuery;
import com.amity.socialcloud.sdk.api.social.post.create.target.AmityPostCreationTarget;
import com.amity.socialcloud.sdk.api.social.post.query.AmityPostQueryTarget;
import com.amity.socialcloud.sdk.api.social.post.reaction.AmityPostReactionQuery;
import com.amity.socialcloud.sdk.api.social.post.review.AmityPostReviewer;
import com.amity.socialcloud.sdk.api.social.post.update.AmityPostUpdate;
import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.ekoapp.ekosdk.internal.usecase.post.FlagPostUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostApproveUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostDeclineUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostDeleteUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostLiveObjectUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.UnFlagPostUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u001b"}, d2={"Lcom/amity/socialcloud/sdk/api/social/post/AmityPostRepository;", "", "()V", "approvePost", "Lio/reactivex/rxjava3/core/Completable;", "postId", "", "createPost", "Lcom/amity/socialcloud/sdk/api/social/post/create/target/AmityPostCreationTarget;", "declinePost", "flagPost", "getComments", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentQuery$Builder;", "getPost", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost;", "getPosts", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityPostQueryTarget;", "getReactions", "Lcom/amity/socialcloud/sdk/api/social/post/reaction/AmityPostReactionQuery$Builder;", "hardDeletePost", "reviewPost", "Lcom/amity/socialcloud/sdk/api/social/post/review/AmityPostReviewer;", "softDeletePost", "unflagPost", "updatePost", "Lcom/amity/socialcloud/sdk/api/social/post/update/AmityPostUpdate$Builder;", "amity-sdk_release"})
public final class AmityPostRepository {
    @NotNull
    public final Flowable<AmityPost> getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostLiveObjectUseCase().execute(postId);
    }

    @NotNull
    public final AmityPostQueryTarget getPosts() {
        return new AmityPostQueryTarget();
    }

    @NotNull
    public final AmityPostCreationTarget createPost() {
        return new AmityPostCreationTarget();
    }

    @NotNull
    public final AmityPostUpdate.Builder updatePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostUpdate.Builder(postId);
    }

    @NotNull
    public final Completable softDeletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeleteUseCase().execute(postId, false);
    }

    @NotNull
    public final Completable hardDeletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeleteUseCase().execute(postId, true);
    }

    @Deprecated(message="Use approvePost() or declinePost() instead")
    @NotNull
    public final AmityPostReviewer reviewPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReviewer(postId);
    }

    @NotNull
    public final AmityPostReactionQuery.Builder getReactions(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReactionQuery.Builder(postId);
    }

    @NotNull
    public final AmityCommentQuery.Builder getComments(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return AmitySocialClient.INSTANCE.newCommentRepository().getComments().post(postId);
    }

    @NotNull
    public final Completable approvePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostApproveUseCase().execute(postId);
    }

    @NotNull
    public final Completable declinePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeclineUseCase().execute(postId);
    }

    @NotNull
    public final Completable flagPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new FlagPostUseCase().execute(postId);
    }

    @NotNull
    public final Completable unflagPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new UnFlagPostUseCase().execute(postId);
    }
}

