/*
 * Decompiled with CFR 0.152.
 */
package org.amity.types;

import java.io.Serializable;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.amity.assertions.Assertions;
import org.amity.diagnostics.Logger;
import org.amity.diagnostics.Loggers;

public final class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = 3670079982654483072L;
    static final Logger LOGGER = Loggers.getLogger("ObjectId");
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int MACHINE_IDENTIFIER;
    private static final short PROCESS_IDENTIFIER;
    private static final AtomicInteger NEXT_COUNTER;
    private static final char[] HEX_CHARS;
    private final int timestamp;
    private final int machineIdentifier;
    private final short processIdentifier;
    private final int counter;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 24) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            char c = hexString.charAt(i2);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static int getGeneratedMachineIdentifier() {
        return MACHINE_IDENTIFIER;
    }

    public static int getGeneratedProcessIdentifier() {
        return PROCESS_IDENTIFIER;
    }

    public static int getCurrentCounter() {
        return NEXT_COUNTER.get();
    }

    public static ObjectId createFromLegacyFormat(int time, int machine, int inc) {
        return new ObjectId(time, machine, inc);
    }

    public ObjectId() {
        this(new Date());
    }

    public ObjectId(Date date) {
        this(ObjectId.dateToTimestampSeconds(date), MACHINE_IDENTIFIER, PROCESS_IDENTIFIER, NEXT_COUNTER.getAndIncrement(), false);
    }

    public ObjectId(Date date, int counter) {
        this(date, MACHINE_IDENTIFIER, PROCESS_IDENTIFIER, counter);
    }

    public ObjectId(Date date, int machineIdentifier, short processIdentifier, int counter) {
        this(ObjectId.dateToTimestampSeconds(date), machineIdentifier, processIdentifier, counter);
    }

    public ObjectId(int timestamp, int machineIdentifier, short processIdentifier, int counter) {
        this(timestamp, machineIdentifier, processIdentifier, counter, true);
    }

    private ObjectId(int timestamp, int machineIdentifier, short processIdentifier, int counter, boolean checkCounter) {
        if ((machineIdentifier & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777215 (it must fit in three bytes).");
        }
        if (checkCounter && (counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        this.timestamp = timestamp;
        this.machineIdentifier = machineIdentifier;
        this.processIdentifier = processIdentifier;
        this.counter = counter & 0xFFFFFF;
    }

    public ObjectId(String hexString) {
        this(ObjectId.parseHexString(hexString));
    }

    public ObjectId(byte[] bytes) {
        this(ByteBuffer.wrap(Assertions.notNull("bytes", bytes)));
    }

    ObjectId(int timestamp, int machineAndProcessIdentifier, int counter) {
        this(ObjectId.legacyToBytes(timestamp, machineAndProcessIdentifier, counter));
    }

    public ObjectId(ByteBuffer buffer) {
        Assertions.notNull("buffer", buffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", buffer.remaining() >= 12);
        this.timestamp = ObjectId.makeInt(buffer.get(), buffer.get(), buffer.get(), buffer.get());
        this.machineIdentifier = ObjectId.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
        this.processIdentifier = (short)ObjectId.makeInt((byte)0, (byte)0, buffer.get(), buffer.get());
        this.counter = ObjectId.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
    }

    private static byte[] legacyToBytes(int timestamp, int machineAndProcessIdentifier, int counter) {
        byte[] bytes = new byte[]{ObjectId.int3(timestamp), ObjectId.int2(timestamp), ObjectId.int1(timestamp), ObjectId.int0(timestamp), ObjectId.int3(machineAndProcessIdentifier), ObjectId.int2(machineAndProcessIdentifier), ObjectId.int1(machineAndProcessIdentifier), ObjectId.int0(machineAndProcessIdentifier), ObjectId.int3(counter), ObjectId.int2(counter), ObjectId.int1(counter), ObjectId.int0(counter)};
        return bytes;
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        this.putToByteBuffer(buffer);
        return buffer.array();
    }

    public void putToByteBuffer(ByteBuffer buffer) {
        Assertions.notNull("buffer", buffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", buffer.remaining() >= 12);
        buffer.put(ObjectId.int3(this.timestamp));
        buffer.put(ObjectId.int2(this.timestamp));
        buffer.put(ObjectId.int1(this.timestamp));
        buffer.put(ObjectId.int0(this.timestamp));
        buffer.put(ObjectId.int2(this.machineIdentifier));
        buffer.put(ObjectId.int1(this.machineIdentifier));
        buffer.put(ObjectId.int0(this.machineIdentifier));
        buffer.put(ObjectId.short1(this.processIdentifier));
        buffer.put(ObjectId.short0(this.processIdentifier));
        buffer.put(ObjectId.int2(this.counter));
        buffer.put(ObjectId.int1(this.counter));
        buffer.put(ObjectId.int0(this.counter));
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getMachineIdentifier() {
        return this.machineIdentifier;
    }

    public short getProcessIdentifier() {
        return this.processIdentifier;
    }

    public int getCounter() {
        return this.counter;
    }

    public Date getDate() {
        return new Date((long)this.timestamp * 1000L);
    }

    public String toHexString() {
        char[] chars = new char[24];
        int i2 = 0;
        for (byte b : this.toByteArray()) {
            chars[i2++] = HEX_CHARS[b >> 4 & 0xF];
            chars[i2++] = HEX_CHARS[b & 0xF];
        }
        return new String(chars);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectId objectId = (ObjectId)o;
        if (this.counter != objectId.counter) {
            return false;
        }
        if (this.machineIdentifier != objectId.machineIdentifier) {
            return false;
        }
        if (this.processIdentifier != objectId.processIdentifier) {
            return false;
        }
        return this.timestamp == objectId.timestamp;
    }

    public int hashCode() {
        int result = this.timestamp;
        result = 31 * result + this.machineIdentifier;
        result = 31 * result + this.processIdentifier;
        result = 31 * result + this.counter;
        return result;
    }

    @Override
    public int compareTo(ObjectId other) {
        if (other == null) {
            throw new NullPointerException();
        }
        byte[] byteArray = this.toByteArray();
        byte[] otherByteArray = other.toByteArray();
        for (int i2 = 0; i2 < 12; ++i2) {
            if (byteArray[i2] == otherByteArray[i2]) continue;
            return (byteArray[i2] & 0xFF) < (otherByteArray[i2] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        return this.toHexString();
    }

    @Deprecated
    public int getTimeSecond() {
        return this.timestamp;
    }

    @Deprecated
    public long getTime() {
        return (long)this.timestamp * 1000L;
    }

    @Deprecated
    public String toStringMongod() {
        return this.toHexString();
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(mac);
                try {
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Throwable t) {
            machinePiece = new SecureRandom().nextInt();
            LOGGER.warn("Failed to get machine identifier from network interface, using random number instead", t);
        }
        return machinePiece &= 0xFFFFFF;
    }

    private static short createProcessIdentifier() {
        return (short)new SecureRandom().nextInt();
    }

    private static byte[] parseHexString(String s) {
        if (!ObjectId.isValid(s)) {
            throw new IllegalArgumentException("invalid hexadecimal representation of an ObjectId: [" + s + "]");
        }
        byte[] b = new byte[12];
        for (int i2 = 0; i2 < b.length; ++i2) {
            b[i2] = (byte)Integer.parseInt(s.substring(i2 * 2, i2 * 2 + 2), 16);
        }
        return b;
    }

    private static int dateToTimestampSeconds(Date time) {
        return (int)(time.getTime() / 1000L);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    static {
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MACHINE_IDENTIFIER = ObjectId.createMachineIdentifier();
            PROCESS_IDENTIFIER = ObjectId.createProcessIdentifier();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

