/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.UserMarkerEntity;
import com.ekoapp.ekosdk.internal.data.dao.UserMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class UserMarkerDao_Impl
extends UserMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserMarkerEntity> __insertionAdapterOfUserMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<UserMarkerEntity> __deletionAdapterOfUserMarkerEntity;
    private final EntityDeletionOrUpdateAdapter<UserMarkerEntity> __updateAdapterOfUserMarkerEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public UserMarkerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserMarkerEntity = new EntityInsertionAdapter<UserMarkerEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_marker` (`userId`,`unreadCount`,`lastSyncAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserMarkerEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                stmt.bindLong(2, (long)value.getUnreadCount());
                String _tmp = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastSyncAt());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfUserMarkerEntity = new EntityDeletionOrUpdateAdapter<UserMarkerEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `user_marker` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserMarkerEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfUserMarkerEntity = new EntityDeletionOrUpdateAdapter<UserMarkerEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user_marker` SET `userId` = ?,`unreadCount` = ?,`lastSyncAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserMarkerEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                stmt.bindLong(2, (long)value.getUnreadCount());
                String _tmp = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastSyncAt());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_marker";
                return "DELETE from user_marker";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_marker where userId = ?";
                return "DELETE from user_marker where userId = ?";
            }
        };
    }

    @Override
    public void insertImpl(UserMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserMarkerEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends UserMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserMarkerEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(UserMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends UserMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserMarkerEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(UserMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUserMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(UserMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            UserMarkerDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends UserMarkerEntity> objects) {
        this.__db.beginTransaction();
        try {
            UserMarkerDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(UserMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            UserMarkerDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    @Override
    public Flowable<UserMarkerEntity> get() {
        String _sql = "SELECT * from user_marker LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_marker LIMIT 1", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_marker"}, (Callable)new Callable<UserMarkerEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserMarkerEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserMarkerDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    UserMarkerEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
                    int _cursorIndexOfLastSyncAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastSyncAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new UserMarkerEntity();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                        _result.setUnreadCount(_tmpUnreadCount);
                        String _tmp = _cursor.isNull(_cursorIndexOfLastSyncAt) ? null : _cursor.getString(_cursorIndexOfLastSyncAt);
                        DateTime _tmpLastSyncAt = UserMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setLastSyncAt(_tmpLastSyncAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = UserMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = UserMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = UserMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    UserMarkerEntity userMarkerEntity = _result;
                    return userMarkerEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

