/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoChannelDao_Impl
extends EkoChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoChannelEntity> __insertionAdapterOfEkoChannelEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoChannelEntity> __deletionAdapterOfEkoChannelEntity;
    private final EntityDeletionOrUpdateAdapter<EkoChannelEntity> __updateAdapterOfEkoChannelEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLastActivity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUnreadCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMessageCount;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMarkerHash;

    public EkoChannelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoChannelEntity = new EntityInsertionAdapter<EkoChannelEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel` (`channelId`,`internalChannelId`,`channelType`,`displayName`,`avatarFileId`,`metadata`,`tags`,`memberCount`,`moderatorMemberCount`,`messageCount`,`isRateLimited`,`isMuted`,`isDeleted`,`lastActivity`,`path`,`channelMarkerHash`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getInternalChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getInternalChannelId());
                }
                if (value.getChannelType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getChannelType());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAvatarFileId());
                }
                String _tmp = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                String _tmp_1 = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, (long)value.getMemberCount());
                stmt.bindLong(9, (long)value.getModeratorMemberCount());
                stmt.bindLong(10, (long)value.getMessageCount());
                int _tmp_2 = value.isRateLimited() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_2);
                int _tmp_3 = value.isMuted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                int _tmp_4 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_4);
                String _tmp_5 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastActivity());
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_5);
                }
                if (value.getPath() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getPath());
                }
                stmt.bindLong(16, (long)value.getChannelMarkerHash());
                String _tmp_6 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_6);
                }
                String _tmp_7 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_7);
                }
                String _tmp_8 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_8);
                }
            }
        };
        this.__deletionAdapterOfEkoChannelEntity = new EntityDeletionOrUpdateAdapter<EkoChannelEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `channel` WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
            }
        };
        this.__updateAdapterOfEkoChannelEntity = new EntityDeletionOrUpdateAdapter<EkoChannelEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel` SET `channelId` = ?,`internalChannelId` = ?,`channelType` = ?,`displayName` = ?,`avatarFileId` = ?,`metadata` = ?,`tags` = ?,`memberCount` = ?,`moderatorMemberCount` = ?,`messageCount` = ?,`isRateLimited` = ?,`isMuted` = ?,`isDeleted` = ?,`lastActivity` = ?,`path` = ?,`channelMarkerHash` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getInternalChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getInternalChannelId());
                }
                if (value.getChannelType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getChannelType());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAvatarFileId());
                }
                String _tmp = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                String _tmp_1 = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, (long)value.getMemberCount());
                stmt.bindLong(9, (long)value.getModeratorMemberCount());
                stmt.bindLong(10, (long)value.getMessageCount());
                int _tmp_2 = value.isRateLimited() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_2);
                int _tmp_3 = value.isMuted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                int _tmp_4 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_4);
                String _tmp_5 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastActivity());
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_5);
                }
                if (value.getPath() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getPath());
                }
                stmt.bindLong(16, (long)value.getChannelMarkerHash());
                String _tmp_6 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_6);
                }
                String _tmp_7 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_7);
                }
                String _tmp_8 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_8);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getChannelId());
                }
            }
        };
        this.__preparedStmtOfUpdateLastActivity = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel set lastActivity = ? where channelId = ?";
                return "UPDATE channel set lastActivity = ? where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateUnreadCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel set channelId = ? where channelId = ?";
                return "UPDATE channel set channelId = ? where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateMessageCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel set messageCount = ? where channelId = ? and messageCount < ?";
                return "UPDATE channel set messageCount = ? where channelId = ? and messageCount < ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel";
                return "DELETE from channel";
            }
        };
        this.__preparedStmtOfDeleteByIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel where channelId = ?";
                return "DELETE from channel where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateMarkerHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel set channelMarkerHash = ? where channelId = ?";
                return "UPDATE channel set channelMarkerHash = ? where channelId = ?";
            }
        };
    }

    @Override
    public void insertImpl(EkoChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoChannelEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends EkoChannelEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoChannelEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoChannelEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends EkoChannelEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoChannelEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(EkoChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoChannelEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteById(String channelId) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.deleteById(channelId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading() {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoChannelEntity channel) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.insert(channel);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends EkoChannelEntity> channels) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.insert(channels);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoChannelEntity channel) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.update(channel);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastActivity(String channelId, DateTime lastActivity) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLastActivity.acquire();
        int _argIndex = 1;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(lastActivity);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLastActivity.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUnreadCount(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUnreadCount.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUnreadCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageCount(String channelId, int messageCount) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMessageCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)messageCount);
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)messageCount);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMessageCount.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByIdImpl(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByIdImpl.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMarkerHash(String channelId, int hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMarkerHash.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)hash);
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMarkerHash.release(_stmt);
        }
    }

    @Override
    public Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannelsImpl(String userId, String membership) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = ?) and channel_membership.userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = ?) and channel_membership.userId = ?", (int)2);
        int _argIndex = 1;
        if (membership == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, membership);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_extra"}, (Callable)new Callable<List<EkoChannelWithMembershipAndExtra>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoChannelWithMembershipAndExtra> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfInternalChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"internalChannelId");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfModeratorMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"moderatorMemberCount");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
                    int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
                    int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
                    int _cursorIndexOfLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_lastMentionedSegment");
                    int _cursorIndexOfLocalLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localLastMentionedSegment");
                    ArrayList<EkoChannelWithMembershipAndExtra> _result = new ArrayList<EkoChannelWithMembershipAndExtra>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoChannelExtra _tmpChannelExtra;
                        ChannelMembershipEntity _tmpChannelMembership;
                        if (!_cursor.isNull(_cursorIndexOfReadToSegment) || !_cursor.isNull(_cursorIndexOfLastMentionedSegment)) {
                            _tmpChannelMembership = new ChannelMembershipEntity();
                            int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                            _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                            int _tmpLastMentionedSegment = _cursor.getInt(_cursorIndexOfLastMentionedSegment);
                            _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                        } else {
                            _tmpChannelMembership = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment) || !_cursor.isNull(_cursorIndexOfLocalLastMentionedSegment)) {
                            _tmpChannelExtra = new EkoChannelExtra(null);
                            int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                            _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                            int _tmpLocalLastMentionedSegment = _cursor.getInt(_cursorIndexOfLocalLastMentionedSegment);
                            _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                        } else {
                            _tmpChannelExtra = null;
                        }
                        EkoChannelWithMembershipAndExtra _item = new EkoChannelWithMembershipAndExtra();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _item.setChannelId(_tmpChannelId);
                        String _tmpInternalChannelId = _cursor.isNull(_cursorIndexOfInternalChannelId) ? null : _cursor.getString(_cursorIndexOfInternalChannelId);
                        _item.setInternalChannelId(_tmpInternalChannelId);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _item.setChannelType(_tmpChannelType);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _item.setDisplayName(_tmpDisplayName);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _item.setAvatarFileId(_tmpAvatarFileId);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _item.setMetadata(_tmpMetadata);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                        _item.setTags(_tmpTags);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        _item.setMemberCount(_tmpMemberCount);
                        int _tmpModeratorMemberCount = _cursor.getInt(_cursorIndexOfModeratorMemberCount);
                        _item.setModeratorMemberCount(_tmpModeratorMemberCount);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _item.setMessageCount(_tmpMessageCount);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                        boolean _tmpIsRateLimited = _tmp_2 != 0;
                        _item.setRateLimited(_tmpIsRateLimited);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsMuted);
                        boolean _tmpIsMuted = _tmp_3 != 0;
                        _item.setMuted(_tmpIsMuted);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_4 != 0;
                        _item.setDeleted(_tmpIsDeleted);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _item.setLastActivity(_tmpLastActivity);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _item.setPath(_tmpPath);
                        int _tmpChannelMarkerHash = _cursor.getInt(_cursorIndexOfChannelMarkerHash);
                        _item.setChannelMarkerHash(_tmpChannelMarkerHash);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _item.setChannelMembership(_tmpChannelMembership);
                        _item.setChannelExtra(_tmpChannelExtra);
                        _result.add(_item);
                    }
                    ArrayList<EkoChannelWithMembershipAndExtra> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoChannelEntity> getLatestChannelImpl(String[] types, boolean isFilterByMemberships, String userId, String[] memberships, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, int hash, int nonce, DateTime now) {
        Integer _tmp_4;
        Integer _tmp_3;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from channel where channel.channelType in (");
        int _inputSize = types.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_membership where membership in (");
        int _inputSize_1 = memberships.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(") and userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(") else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_2 = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(")) else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId not in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_3 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_3);
        _stringBuilder.append(")) else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then channel.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else channel.channelId is not null end and channel.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and channel.channelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by channel.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 9 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : types) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        int _tmp = isFilterByMemberships ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2 + _inputSize;
        for (String _item_1 : memberships) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize + _inputSize_1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 3 + _inputSize + _inputSize_1;
        int _tmp_1 = isIncludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 4 + _inputSize + _inputSize_1;
        for (String _item_2 : includingTags) {
            if (_item_2 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_2);
            }
            ++_argIndex;
        }
        _argIndex = 4 + _inputSize + _inputSize_1 + _inputSize_2;
        int _tmp_2 = isExcludingTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2;
        for (String _item_3 : excludingTags) {
            if (_item_3 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_3);
            }
            ++_argIndex;
        }
        _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        Integer n = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        _argIndex = 6 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        Integer n2 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 7 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        String _tmp_5 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_5 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_5);
        }
        _argIndex = 8 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 9 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_tag", "amity_paging_id"}, (Callable)new Callable<EkoChannelEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoChannelEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoChannelEntity _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfInternalChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"internalChannelId");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfModeratorMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"moderatorMemberCount");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
                    int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoChannelEntity();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpInternalChannelId = _cursor.isNull(_cursorIndexOfInternalChannelId) ? null : _cursor.getString(_cursorIndexOfInternalChannelId);
                        _result.setInternalChannelId(_tmpInternalChannelId);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _result.setChannelType(_tmpChannelType);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_7);
                        _result.setTags(_tmpTags);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        _result.setMemberCount(_tmpMemberCount);
                        int _tmpModeratorMemberCount = _cursor.getInt(_cursorIndexOfModeratorMemberCount);
                        _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _result.setMessageCount(_tmpMessageCount);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                        boolean _tmpIsRateLimited = _tmp_8 != 0;
                        _result.setRateLimited(_tmpIsRateLimited);
                        int _tmp_9 = _cursor.getInt(_cursorIndexOfIsMuted);
                        boolean _tmpIsMuted = _tmp_9 != 0;
                        _result.setMuted(_tmpIsMuted);
                        int _tmp_10 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_10 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setLastActivity(_tmpLastActivity);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        int _tmpChannelMarkerHash = _cursor.getInt(_cursorIndexOfChannelMarkerHash);
                        _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoChannelEntity ekoChannelEntity = _result;
                    return ekoChannelEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoChannelWithMembershipAndExtra> getChannelImpl(String channelId) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_extra"}, (Callable)new Callable<EkoChannelWithMembershipAndExtra>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoChannelWithMembershipAndExtra call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoChannelWithMembershipAndExtra _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfInternalChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"internalChannelId");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfModeratorMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"moderatorMemberCount");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
                    int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelMarkerHash");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
                    int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
                    int _cursorIndexOfLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_lastMentionedSegment");
                    int _cursorIndexOfLocalLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localLastMentionedSegment");
                    if (_cursor.moveToFirst()) {
                        EkoChannelExtra _tmpChannelExtra;
                        ChannelMembershipEntity _tmpChannelMembership;
                        if (!_cursor.isNull(_cursorIndexOfReadToSegment) || !_cursor.isNull(_cursorIndexOfLastMentionedSegment)) {
                            _tmpChannelMembership = new ChannelMembershipEntity();
                            int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                            _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                            int _tmpLastMentionedSegment = _cursor.getInt(_cursorIndexOfLastMentionedSegment);
                            _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                        } else {
                            _tmpChannelMembership = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment) || !_cursor.isNull(_cursorIndexOfLocalLastMentionedSegment)) {
                            _tmpChannelExtra = new EkoChannelExtra(null);
                            int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                            _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                            int _tmpLocalLastMentionedSegment = _cursor.getInt(_cursorIndexOfLocalLastMentionedSegment);
                            _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                        } else {
                            _tmpChannelExtra = null;
                        }
                        _result = new EkoChannelWithMembershipAndExtra();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpInternalChannelId = _cursor.isNull(_cursorIndexOfInternalChannelId) ? null : _cursor.getString(_cursorIndexOfInternalChannelId);
                        _result.setInternalChannelId(_tmpInternalChannelId);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _result.setChannelType(_tmpChannelType);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                        _result.setTags(_tmpTags);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        _result.setMemberCount(_tmpMemberCount);
                        int _tmpModeratorMemberCount = _cursor.getInt(_cursorIndexOfModeratorMemberCount);
                        _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _result.setMessageCount(_tmpMessageCount);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                        boolean _tmpIsRateLimited = _tmp_2 != 0;
                        _result.setRateLimited(_tmpIsRateLimited);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsMuted);
                        boolean _tmpIsMuted = _tmp_3 != 0;
                        _result.setMuted(_tmpIsMuted);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_4 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setLastActivity(_tmpLastActivity);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        int _tmpChannelMarkerHash = _cursor.getInt(_cursorIndexOfChannelMarkerHash);
                        _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setExpiresAt(_tmpExpiresAt);
                        _result.setChannelMembership(_tmpChannelMembership);
                        _result.setChannelExtra(_tmpChannelExtra);
                    } else {
                        _result = null;
                    }
                    EkoChannelWithMembershipAndExtra ekoChannelWithMembershipAndExtra = _result;
                    return ekoChannelWithMembershipAndExtra;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelWithMembershipAndExtra getByIdNowImpl(String channelId) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoChannelWithMembershipAndExtra _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfInternalChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"internalChannelId");
            int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
            int _cursorIndexOfModeratorMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"moderatorMemberCount");
            int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
            int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
            int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
            int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
            int _cursorIndexOfLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_lastMentionedSegment");
            int _cursorIndexOfLocalLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localLastMentionedSegment");
            if (_cursor.moveToFirst()) {
                EkoChannelExtra _tmpChannelExtra;
                ChannelMembershipEntity _tmpChannelMembership;
                if (!_cursor.isNull(_cursorIndexOfReadToSegment) || !_cursor.isNull(_cursorIndexOfLastMentionedSegment)) {
                    _tmpChannelMembership = new ChannelMembershipEntity();
                    int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                    _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = _cursor.getInt(_cursorIndexOfLastMentionedSegment);
                    _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                } else {
                    _tmpChannelMembership = null;
                }
                if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment) || !_cursor.isNull(_cursorIndexOfLocalLastMentionedSegment)) {
                    _tmpChannelExtra = new EkoChannelExtra(null);
                    int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                    _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                    int _tmpLocalLastMentionedSegment = _cursor.getInt(_cursorIndexOfLocalLastMentionedSegment);
                    _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                } else {
                    _tmpChannelExtra = null;
                }
                _result = new EkoChannelWithMembershipAndExtra();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpInternalChannelId = _cursor.isNull(_cursorIndexOfInternalChannelId) ? null : _cursor.getString(_cursorIndexOfInternalChannelId);
                _result.setInternalChannelId(_tmpInternalChannelId);
                String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                _result.setChannelType(_tmpChannelType);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                _result.setDisplayName(_tmpDisplayName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _result.setAvatarFileId(_tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                _result.setTags(_tmpTags);
                int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                _result.setMemberCount(_tmpMemberCount);
                int _tmpModeratorMemberCount = _cursor.getInt(_cursorIndexOfModeratorMemberCount);
                _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                _result.setMessageCount(_tmpMessageCount);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                boolean _tmpIsRateLimited = _tmp_2 != 0;
                _result.setRateLimited(_tmpIsRateLimited);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsMuted);
                boolean _tmpIsMuted = _tmp_3 != 0;
                _result.setMuted(_tmpIsMuted);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_4 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setLastActivity(_tmpLastActivity);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                int _tmpChannelMarkerHash = _cursor.getInt(_cursorIndexOfChannelMarkerHash);
                _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setExpiresAt(_tmpExpiresAt);
                _result.setChannelMembership(_tmpChannelMembership);
                _result.setChannelExtra(_tmpChannelExtra);
            } else {
                _result = null;
            }
            EkoChannelWithMembershipAndExtra ekoChannelWithMembershipAndExtra = _result;
            return ekoChannelWithMembershipAndExtra;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelEntity getByInternalIdNowImpl(String internalId) {
        String _sql = "SELECT channel.* from channel where channel.internalChannelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channel.* from channel where channel.internalChannelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (internalId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, internalId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoChannelEntity _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfInternalChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"internalChannelId");
            int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
            int _cursorIndexOfModeratorMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"moderatorMemberCount");
            int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
            int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
            int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoChannelEntity();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpInternalChannelId = _cursor.isNull(_cursorIndexOfInternalChannelId) ? null : _cursor.getString(_cursorIndexOfInternalChannelId);
                _result.setInternalChannelId(_tmpInternalChannelId);
                String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                _result.setChannelType(_tmpChannelType);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                _result.setDisplayName(_tmpDisplayName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _result.setAvatarFileId(_tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                _result.setTags(_tmpTags);
                int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                _result.setMemberCount(_tmpMemberCount);
                int _tmpModeratorMemberCount = _cursor.getInt(_cursorIndexOfModeratorMemberCount);
                _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                _result.setMessageCount(_tmpMessageCount);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                boolean _tmpIsRateLimited = _tmp_2 != 0;
                _result.setRateLimited(_tmpIsRateLimited);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsMuted);
                boolean _tmpIsMuted = _tmp_3 != 0;
                _result.setMuted(_tmpIsMuted);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_4 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setLastActivity(_tmpLastActivity);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                int _tmpChannelMarkerHash = _cursor.getInt(_cursorIndexOfChannelMarkerHash);
                _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            EkoChannelEntity ekoChannelEntity = _result;
            return ekoChannelEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoChannelWithMembershipAndExtra> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId  IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfInternalChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"internalChannelId");
            int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
            int _cursorIndexOfModeratorMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"moderatorMemberCount");
            int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
            int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
            int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelMarkerHash");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
            int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
            int _cursorIndexOfLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_lastMentionedSegment");
            int _cursorIndexOfLocalLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localLastMentionedSegment");
            ArrayList<EkoChannelWithMembershipAndExtra> _result = new ArrayList<EkoChannelWithMembershipAndExtra>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoChannelExtra _tmpChannelExtra;
                ChannelMembershipEntity _tmpChannelMembership;
                if (!_cursor.isNull(_cursorIndexOfReadToSegment) || !_cursor.isNull(_cursorIndexOfLastMentionedSegment)) {
                    _tmpChannelMembership = new ChannelMembershipEntity();
                    int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                    _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = _cursor.getInt(_cursorIndexOfLastMentionedSegment);
                    _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                } else {
                    _tmpChannelMembership = null;
                }
                if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment) || !_cursor.isNull(_cursorIndexOfLocalLastMentionedSegment)) {
                    _tmpChannelExtra = new EkoChannelExtra(null);
                    int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                    _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                    int _tmpLocalLastMentionedSegment = _cursor.getInt(_cursorIndexOfLocalLastMentionedSegment);
                    _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                } else {
                    _tmpChannelExtra = null;
                }
                EkoChannelWithMembershipAndExtra _item_1 = new EkoChannelWithMembershipAndExtra();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item_1.setChannelId(_tmpChannelId);
                String _tmpInternalChannelId = _cursor.isNull(_cursorIndexOfInternalChannelId) ? null : _cursor.getString(_cursorIndexOfInternalChannelId);
                _item_1.setInternalChannelId(_tmpInternalChannelId);
                String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                _item_1.setChannelType(_tmpChannelType);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                _item_1.setDisplayName(_tmpDisplayName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setMetadata(_tmpMetadata);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                _item_1.setTags(_tmpTags);
                int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                _item_1.setMemberCount(_tmpMemberCount);
                int _tmpModeratorMemberCount = _cursor.getInt(_cursorIndexOfModeratorMemberCount);
                _item_1.setModeratorMemberCount(_tmpModeratorMemberCount);
                int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                _item_1.setMessageCount(_tmpMessageCount);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                boolean _tmpIsRateLimited = _tmp_2 != 0;
                _item_1.setRateLimited(_tmpIsRateLimited);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsMuted);
                boolean _tmpIsMuted = _tmp_3 != 0;
                _item_1.setMuted(_tmpIsMuted);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_4 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _item_1.setLastActivity(_tmpLastActivity);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item_1.setPath(_tmpPath);
                int _tmpChannelMarkerHash = _cursor.getInt(_cursorIndexOfChannelMarkerHash);
                _item_1.setChannelMarkerHash(_tmpChannelMarkerHash);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _item_1.setChannelMembership(_tmpChannelMembership);
                _item_1.setChannelExtra(_tmpChannelExtra);
                _result.add(_item_1);
            }
            ArrayList<EkoChannelWithMembershipAndExtra> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<List<String>> getActiveIds(String userId) {
        String _sql = "SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = ?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = ?)", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership"}, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                        _result.add(_item);
                    }
                    ArrayList<String> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getInactiveIds(String userId) {
        String _sql = "SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = ?)", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

