/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.session.AmityGlobalBanEvent;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.api.event.StreamDidStartListener;
import com.ekoapp.ekosdk.internal.api.event.StreamDidStopListener;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jakewharton.rxrelay3.BehaviorRelay;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "destroy", "", "disconnect", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "handleTokenExpire", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "terminateSocket", "Companion", "amity-sdk_release"})
public final class EkoSocket
extends SessionComponent {
    private static final String TAG;
    private static final Socket PROXY;
    private static final AtomicInteger rpcId;
    private static EkoAccount currentAccount;
    private static Socket currentSocket;
    private static Dispatcher currentDispatcher;
    private static final BehaviorRelay<SocketConnectionEvent> connectionEventRelay;
    private static final PublishSubject<AmityGlobalBanEvent> globalBanEventPublisher;
    private static SessionStateEventBus companionSessionStateEventBus;
    @NotNull
    public static final Companion Companion;

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.terminateSocket();
        currentSocket = EkoSocket.Companion.init(account);
        currentSocket.connect();
    }

    @Override
    public void destroy() {
        this.terminateSocket();
    }

    @Override
    public void handleTokenExpire() {
        this.terminateSocket();
    }

    public final void disconnect() {
        this.terminateSocket();
    }

    private final void terminateSocket() {
        if (currentSocket.connected()) {
            currentSocket.disconnect();
        }
        currentDispatcher.executorService().shutdown();
        String socketHash = Integer.toHexString(currentSocket.hashCode());
        AmityLog.INSTANCE.e("socket", new Object[]{"terminate socket: " + socketHash});
    }

    public EkoSocket(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        companionSessionStateEventBus = this.getSessionStateEventBus();
    }

    static {
        Companion = new Companion(null);
        TAG = EkoSocket.class.getName();
        PROXY = new Socket(null, null, null);
        rpcId = new AtomicInteger(0);
        currentAccount = EkoAccount.create("seed");
        currentSocket = PROXY;
        currentDispatcher = new Dispatcher();
        connectionEventRelay = BehaviorRelay.create();
        globalBanEventPublisher = PublishSubject.create();
    }

    public static final /* synthetic */ EkoAccount access$getCurrentAccount$cp() {
        return currentAccount;
    }

    public static final /* synthetic */ Socket access$getCurrentSocket$cp() {
        return currentSocket;
    }

    public static final /* synthetic */ void access$setCurrentSocket$cp(Socket socket) {
        currentSocket = socket;
    }

    public static final /* synthetic */ SessionStateEventBus access$getCompanionSessionStateEventBus$cp() {
        return companionSessionStateEventBus;
    }

    public static final /* synthetic */ void access$setCompanionSessionStateEventBus$cp(SessionStateEventBus sessionStateEventBus) {
        companionSessionStateEventBus = sessionStateEventBus;
    }

    @JvmStatic
    @NotNull
    public static final Flowable<SocketConnectionEvent> connectionEvent() {
        return Companion.connectionEvent();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0007J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R<\u0010\n\u001a0\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f \u0007*\u0017\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b\u00a2\u0006\u0002\b\r0\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R<\u0010\u0013\u001a0\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00150\u0015 \u0007*\u0017\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u0014\u00a2\u0006\u0002\b\r0\u0014\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoSocket$Companion;", "", "()V", "PROXY", "Lio/socket/client/Socket;", "TAG", "", "kotlin.jvm.PlatformType", "companionSessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "connectionEventRelay", "Lcom/jakewharton/rxrelay3/BehaviorRelay;", "Lcom/ekoapp/ekosdk/internal/api/SocketConnectionEvent;", "Lio/reactivex/rxjava3/annotations/NonNull;", "currentAccount", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "currentDispatcher", "Lokhttp3/Dispatcher;", "currentSocket", "globalBanEventPublisher", "Lio/reactivex/rxjava3/subjects/PublishSubject;", "Lcom/amity/socialcloud/sdk/model/core/session/AmityGlobalBanEvent;", "globalBanEvents", "Lio/reactivex/rxjava3/core/Flowable;", "getGlobalBanEvents", "()Lio/reactivex/rxjava3/core/Flowable;", "rpcId", "Ljava/util/concurrent/atomic/AtomicInteger;", "connectionEvent", "init", "account", "subscribeSocketEvent", "", "socket", "listener", "Lcom/ekoapp/ekosdk/internal/api/event/SocketEventListener;", "amity-sdk_release"})
    public static final class Companion {
        private final Socket init(EkoAccount account) throws URISyntaxException {
            currentDispatcher = new Dispatcher();
            currentAccount = account;
            String string = account.getUserId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.userId");
            String userId = string;
            String authority = EkoEndpoint.INSTANCE.getSocketUrl();
            AmityLog.INSTANCE.i(TAG, new Object[]{"init new socket for: %s , url: %s", userId, authority});
            OkHttpClient okHttpClient = new OkHttpClient.Builder().dispatcher(currentDispatcher).readTimeout(1L, TimeUnit.MINUTES).build();
            IO.Options options = new IO.Options();
            options.callFactory = (Call.Factory)okHttpClient;
            options.webSocketFactory = (WebSocket.Factory)okHttpClient;
            options.reconnectionDelayMax = 10000L;
            options.transports = new String[]{"websocket"};
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "token=%s";
            Object[] objectArray = new Object[]{account.getAccessToken()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            options.query = string3;
            Socket socket = IO.socket((String)authority, (IO.Options)options);
            ImmutableSet immutableSet = ImmutableSet.builder().add((Object)"connect").add((Object)"connect_error").add((Object)"connect_timeout").add((Object)"connecting").add((Object)"disconnect").add((Object)"error").add((Object)"reconnect").add((Object)"reconnect_attempt").add((Object)"reconnect_failed").add((Object)"reconnecting").add((Object)"ping").add((Object)"pong").add((Object)"message").build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"ImmutableSet.builder<Str\u2026\n                .build()");
            Set events = (Set)immutableSet;
            for (String event : events) {
                socket.on(event, new Emitter.Listener(socket, userId, event){
                    final /* synthetic */ Socket $socket;
                    final /* synthetic */ String $userId;
                    final /* synthetic */ String $event;

                    public final void call(@Nullable Object[] args) {
                        if (Objects.equal((Object)this.$socket, (Object)EkoSocket.access$getCurrentSocket$cp())) {
                            Intrinsics.checkNotNull((Object)args);
                            SocketConnectionEvent sce = new SocketConnectionEvent(this.$userId, this.$socket, this.$event, args);
                            EkoSocket.access$getConnectionEventRelay$cp().accept((Object)sce);
                        }
                    }
                    {
                        this.$socket = socket;
                        this.$userId = string;
                        this.$event = string2;
                    }
                });
            }
            socket.on("disconnect", new Emitter.Listener(socket){
                final /* synthetic */ Socket $socket;

                public final void call(@NotNull Object[] args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    if (args.length > 0 && Objects.equal((Object)args[0], (Object)"io server disconnect")) {
                        this.$socket.connect();
                    }
                }
                {
                    this.$socket = socket;
                }
            });
            socket.on("error", new Emitter.Listener(userId){
                final /* synthetic */ String $userId;

                public final void call(@Nullable Object[] args) {
                    try {
                        JsonElement element;
                        String string = EkoSocket.access$getTAG$cp();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                        AmityLog.INSTANCE.tag(string).e(">>>>>>>>>>>>>args: " + args, new Object[0]);
                        JsonParser parser = new JsonParser();
                        JsonElement jsonElement = element = parser.parse(Arrays.deepToString(args));
                        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"element");
                        JsonArray array = jsonElement.getAsJsonArray();
                        JsonElement jsonElement2 = array.get(0);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"array[0]");
                        JsonObject object = jsonElement2.getAsJsonObject();
                        JsonElement jsonElement3 = object.get("message");
                        Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"`object`[\"message\"]");
                        String string2 = jsonElement3.getAsString();
                        JsonElement jsonElement4 = object.get("code");
                        Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"`object`[\"code\"]");
                        AmityException exception = AmityException.Companion.create(string2, null, jsonElement4.getAsInt());
                        if (AmityError.Companion.from(exception).is(AmityError.USER_IS_GLOBAL_BANNED)) {
                            EkoSocket.access$getGlobalBanEventPublisher$cp().onNext((Object)new AmityGlobalBanEvent(this.$userId));
                            SessionStateEventBus sessionStateEventBus = EkoSocket.access$getCompanionSessionStateEventBus$cp();
                            if (sessionStateEventBus == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"companionSessionStateEventBus");
                            }
                            sessionStateEventBus.publish(new SessionState.Terminated(exception));
                        }
                    }
                    catch (Exception e) {
                        String string = EkoSocket.access$getTAG$cp();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                        AmityLog amityLog = AmityLog.INSTANCE.tag(string);
                        Throwable throwable = e;
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string3 = "event: error arg: %s";
                        Object[] objectArray = new Object[]{Arrays.deepToString(args)};
                        boolean bl = false;
                        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                        amityLog.e(throwable, string4, new Object[0]);
                    }
                }
                {
                    this.$userId = string;
                }
            });
            Completable.fromAction((Action)init.4.INSTANCE).subscribeOn(Schedulers.io()).subscribe();
            Socket socket2 = socket;
            Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"socket");
            this.subscribeSocketEvent(socket2, new StreamDidStartListener());
            this.subscribeSocketEvent(socket, new StreamDidStopListener());
            return socket;
        }

        private final void subscribeSocketEvent(Socket socket, SocketEventListener listener) {
            socket.on(listener.getEvent(), (Emitter.Listener)listener);
        }

        @JvmStatic
        @NotNull
        public final Flowable<SocketConnectionEvent> connectionEvent() {
            Flowable flowable = connectionEventRelay.toFlowable(BackpressureStrategy.BUFFER);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"this.connectionEventRela\u2026kpressureStrategy.BUFFER)");
            return flowable;
        }

        @NotNull
        public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
            Flowable flowable = globalBanEventPublisher.toFlowable(BackpressureStrategy.BUFFER);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"globalBanEventPublisher.\u2026kpressureStrategy.BUFFER)");
            return flowable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

