/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.comment;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionee;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.domain.comment.LatestRepliesGetUseCase;
import com.amity.socialcloud.sdk.social.domain.comment.flag.IsCommentFlaggedByMeUseCase;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/comment/CommentComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "()V", "addCommentUser", "", "comment", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "addData", "addLatestReplies", "addMentioneeUser", "addMyFlag", "addMyReactions", "execute", "getAttachment", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment$Attachment;", "attachment", "Lcom/google/gson/JsonObject;", "amity-sdk_release"})
public final class CommentComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityComment execute(@NotNull AmityComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.addLatestReplies(comment);
        this.addMyReactions(comment);
        this.addMyFlag(comment);
        this.addCommentUser(comment);
        this.addMentioneeUser(comment);
        this.addData(comment);
        return comment;
    }

    private final void addMyReactions(AmityComment comment) {
        comment.setMyReactions$amity_sdk_release(new MyReactionsGetUseCase().execute(AmityReactionReferenceType.COMMENT, comment.getCommentId()));
    }

    private final void addMyFlag(AmityComment comment) {
        comment.setFlaggedByMe$amity_sdk_release(new IsCommentFlaggedByMeUseCase().execute(comment.getCommentId()));
    }

    private final void addCommentUser(AmityComment comment) {
        comment.setUser$amity_sdk_release(new UserGetUseCase().execute(comment.getCreatorId()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMentioneeUser(AmityComment comment) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = comment.getMentionees();
        AmityComment amityComment = comment;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityMentionee amityMentionee = (AmityMentionee)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof AmityMentionee.USER) {
                ((AmityMentionee.USER)it).setUser$amity_sdk_release(new UserGetUseCase().execute(((AmityMentionee.USER)it).getUserId()));
            }
            void var13_13 = it;
            collection.add(var13_13);
        }
        collection = (List)destination$iv$iv;
        amityComment.setMentionees$amity_sdk_release((List<? extends AmityMentionee>)collection);
    }

    private final void addLatestReplies(AmityComment comment) {
        comment.setLatestReplies$amity_sdk_release(new LatestRepliesGetUseCase().execute(comment.getReferenceType$amity_sdk_release(), comment.getReferenceId$amity_sdk_release(), comment.getCommentId()));
    }

    private final void addData(AmityComment comment) {
        boolean bl;
        JsonObject it$iv$iv;
        Object object;
        boolean bl2;
        boolean bl3;
        JsonElement it;
        boolean bl4;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        JsonArray jsonArray = comment.getRawAttachments$amity_sdk_release().getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"comment.rawAttachments.asJsonArray");
        Iterable iterable = (Iterable)jsonArray;
        AmityComment amityComment = comment;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl4 = false;
            it = (JsonElement)element$iv$iv;
            boolean bl5 = false;
            JsonElement jsonElement = it;
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"it");
            if (jsonElement.getAsJsonObject() == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = object;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$mapNotNull$iv = list2;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl4 = false;
            it = (JsonObject)element$iv$iv;
            boolean bl6 = false;
            if (this.getAttachment((JsonObject)it) == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = object;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        amityComment.setAttachments$amity_sdk_release(list2);
    }

    private final AmityComment.Attachment getAttachment(JsonObject attachment) {
        JsonElement jsonElement = attachment.get("type");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"attachment.get(\"type\")");
        String string = jsonElement.getAsString();
        if (Intrinsics.areEqual((Object)string, (Object)AmityComment.DataType.IMAGE.getApiKey())) {
            AmityComment.Attachment.IMAGE iMAGE;
            String fileId;
            JsonElement jsonElement2 = attachment.get("fileId");
            String string2 = fileId = jsonElement2 != null ? jsonElement2.getAsString() : null;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                iMAGE = new AmityComment.Attachment.IMAGE(fileId, new ImageGetUseCase().execute(it));
            } else {
                iMAGE = null;
            }
            return iMAGE;
        }
        return null;
    }
}

