/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session.component;

import com.amity.socialcloud.sdk.core.session.AccessTokenRenewalImpl;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "currentRenewal", "Lcom/amity/socialcloud/sdk/core/session/AccessTokenRenewalImpl;", "lastFailedDateTime", "Lorg/joda/time/DateTime;", "kotlin.jvm.PlatformType", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "getSessionHandler", "()Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "setSessionHandler", "(Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;)V", "canInitiateRenewal", "", "destroy", "", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "finishCurrentRenewal", "handleTokenExpire", "initiateRenewal", "renewal", "initiateRenewalIfNeeded", "observeTokenEvent", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "unableToRenewWithCurrentRenewal", "amity-sdk_release"})
public final class TokenRenewalSessionComponent
extends SessionComponent {
    @Nullable
    private SessionHandler sessionHandler;
    private AccessTokenRenewalImpl currentRenewal;
    private DateTime lastFailedDateTime;
    private final AppEventBus appEventBus;

    @Nullable
    public final SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public final void setSessionHandler(@Nullable SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
    }

    @Override
    public void destroy() {
    }

    @Override
    public void handleTokenExpire() {
        this.finishCurrentRenewal();
    }

    private final void observeTokenEvent() {
        this.appEventBus.observe().filter((Predicate)observeTokenEvent.1.INSTANCE).doOnNext((Consumer)new Consumer<AppEvent>(this){
            final /* synthetic */ TokenRenewalSessionComponent this$0;

            public final void accept(AppEvent it) {
                TokenRenewalSessionComponent.access$initiateRenewalIfNeeded(this.this$0);
            }
            {
                this.this$0 = tokenRenewalSessionComponent;
            }
        }).subscribe();
    }

    private final void initiateRenewalIfNeeded() {
        block1: {
            if (!this.canInitiateRenewal()) {
                return;
            }
            SessionLifeCycleEventBus sessionLifeCycleEventBus = this.getSessionLifeCycleEventBus();
            AppEventBus appEventBus = this.appEventBus;
            Function0 function0 = (Function0)new Function0<Unit>(this){
                final /* synthetic */ TokenRenewalSessionComponent this$0;

                public final void invoke() {
                    TokenRenewalSessionComponent.access$unableToRenewWithCurrentRenewal(this.this$0);
                }
                {
                    this.this$0 = tokenRenewalSessionComponent;
                    super(0);
                }
            };
            Function1 function1 = (Function1)new Function1<Throwable, Unit>(this){
                final /* synthetic */ TokenRenewalSessionComponent this$0;

                public final void invoke(@NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    AmityException amityError = AmityException.Companion.fromThrowable(throwable);
                    if (amityError.getCode() == AmityError.USER_IS_GLOBAL_BANNED.getCode() || amityError.getCode() == AmityError.UNAUTHORIZED_ERROR.getCode()) {
                        TokenRenewalSessionComponent.access$getAppEventBus$p(this.this$0).publish(new AppEvent.TerminationCodeReceive(amityError));
                        TokenRenewalSessionComponent.access$finishCurrentRenewal(this.this$0);
                    } else {
                        TokenRenewalSessionComponent.access$unableToRenewWithCurrentRenewal(this.this$0);
                    }
                }
                {
                    this.this$0 = tokenRenewalSessionComponent;
                    super(1);
                }
            };
            Function0 function02 = (Function0)new Function0<Unit>(this){
                final /* synthetic */ TokenRenewalSessionComponent this$0;

                public final void invoke() {
                    TokenRenewalSessionComponent.access$getAppEventBus$p(this.this$0).publish(AppEvent.TokenRenewSuccess.INSTANCE);
                    TokenRenewalSessionComponent.access$finishCurrentRenewal(this.this$0);
                }
                {
                    this.this$0 = tokenRenewalSessionComponent;
                    super(0);
                }
            };
            AccessTokenRenewalImpl accessTokenRenewal2 = new AccessTokenRenewalImpl(appEventBus, sessionLifeCycleEventBus, (Function0<Unit>)function02, (Function1<? super Throwable, Unit>)function1, (Function0<Unit>)function0);
            this.initiateRenewal(accessTokenRenewal2);
            SessionHandler sessionHandler = this.sessionHandler;
            if (sessionHandler == null) break block1;
            sessionHandler.sessionWillRenewAccessToken(accessTokenRenewal2);
        }
    }

    private final void initiateRenewal(AccessTokenRenewalImpl renewal) {
        this.currentRenewal = renewal;
    }

    private final boolean canInitiateRenewal() {
        if (this.currentRenewal != null) {
            return false;
        }
        Duration tenMinutes = Duration.standardMinutes((long)10L);
        return this.currentRenewal == null || !DateTime.now().isAfter((ReadableInstant)this.lastFailedDateTime.plus((ReadableDuration)tenMinutes));
    }

    private final void unableToRenewWithCurrentRenewal() {
        AccessTokenRenewalImpl accessTokenRenewalImpl = this.currentRenewal;
        if (accessTokenRenewalImpl != null) {
            accessTokenRenewalImpl.invalidate();
        }
        this.currentRenewal = null;
        this.lastFailedDateTime = DateTime.now();
    }

    private final void finishCurrentRenewal() {
        AccessTokenRenewalImpl accessTokenRenewalImpl = this.currentRenewal;
        if (accessTokenRenewalImpl != null) {
            accessTokenRenewalImpl.invalidate();
        }
        this.currentRenewal = null;
        this.lastFailedDateTime = DateTime.now().minus((ReadableDuration)Duration.standardDays((long)999L));
    }

    public TokenRenewalSessionComponent(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.appEventBus = appEventBus;
        this.lastFailedDateTime = DateTime.now().minus((ReadableDuration)Duration.standardDays((long)999L));
        this.observeTokenEvent();
    }

    public static final /* synthetic */ void access$initiateRenewalIfNeeded(TokenRenewalSessionComponent $this) {
        $this.initiateRenewalIfNeeded();
    }

    public static final /* synthetic */ AppEventBus access$getAppEventBus$p(TokenRenewalSessionComponent $this) {
        return $this.appEventBus;
    }

    public static final /* synthetic */ void access$finishCurrentRenewal(TokenRenewalSessionComponent $this) {
        $this.finishCurrentRenewal();
    }

    public static final /* synthetic */ void access$unableToRenewWithCurrentRenewal(TokenRenewalSessionComponent $this) {
        $this.unableToRenewWithCurrentRenewal();
    }
}

