/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.api.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.api.core.notification.AmityNotification;
import com.amity.socialcloud.sdk.api.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.api.core.reaction.AmityReactionRepository;
import com.amity.socialcloud.sdk.api.core.session.AmitySessionEstablisher;
import com.amity.socialcloud.sdk.api.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.api.core.user.notification.AmityUserNotification;
import com.amity.socialcloud.sdk.api.core.user.update.AmityUserUpdate;
import com.amity.socialcloud.sdk.chat.data.marker.user.ObserveUserMarker;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.MarkReadEngine;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.DatabaseSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.UserSettingSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.content.AmityContentCheck;
import com.amity.socialcloud.sdk.model.core.events.AmityTopic;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.model.core.session.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.data.stream.StreamFunction;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function4;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0*J\r\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0J\u0006\u00101\u001a\u00020\u0004J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00042\b\u00109\u001a\u0004\u0018\u00010:J\u0006\u0010;\u001a\u00020\"J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020EJ\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\b0*J\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00100*J\u0006\u0010H\u001a\u00020\"J\u0006\u0010I\u001a\u00020\"J\u000e\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020\u0004J\u0016\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020MJ\b\u0010N\u001a\u00020OH\u0002J\u0006\u0010P\u001a\u00020OJ\u0016\u0010Q\u001a\u00020\"2\u0006\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u0004J\u0006\u0010T\u001a\u00020OJ\u0016\u0010U\u001a\u00020\"2\u0006\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u0004J\u000e\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YJ\u0006\u0010Z\u001a\u00020\"J\u0006\u0010[\u001a\u00020\"J\u0006\u0010\\\u001a\u00020]R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/amity/socialcloud/sdk/core/CoreClient;", "", "()V", "TAG", "", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "currentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentSessionState", "()Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "markReadEngine", "Lcom/amity/socialcloud/sdk/core/MarkReadEngine;", "markerSyncEngine", "Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine;", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "mqttClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "renewalManager", "Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "sessionStateManager", "Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "socketClient", "Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "getAmityCoreSdkVersion", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getContentCheck", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentCheck;", "getCurrentUser", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/model/core/session/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/api/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/model/core/permission/AmityPermission;", "login", "Lcom/amity/socialcloud/sdk/api/core/session/AmitySessionEstablisher$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "logout", "newFileRepository", "Lcom/amity/socialcloud/sdk/api/core/file/AmityFileRepository;", "newReactionRepository", "Lcom/amity/socialcloud/sdk/api/core/reaction/AmityReactionRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/api/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/api/core/user/notification/AmityUserNotification;", "notifications", "Lcom/amity/socialcloud/sdk/api/core/notification/AmityNotification;", "observeSessionState", "observeUserUnreadCount", "registerDeviceForPushNotification", "registerPushNotification", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/api/core/endpoint/AmityEndpoint;", "setupSessionComponents", "", "startMarkerSyncing", "startReading", "subChannelId", "channelId", "stopMarkerSyncing", "stopReading", "subscription", "Lcom/amity/socialcloud/sdk/api/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "unregisterPushNotification", "updateUser", "Lcom/amity/socialcloud/sdk/api/core/user/update/AmityUserUpdate$Builder;", "amity-sdk_release"})
public final class CoreClient {
    private static final String TAG = "AmityCoreClient";
    private static int millisTimeDiff;
    private static AmityMqttClient mqttClient;
    private static EkoSocket socketClient;
    private static TokenRenewalSessionComponent renewalManager;
    private static final SessionLifeCycleEventBus sessionLifeCycleEventBus;
    private static final AppEventBus appEventBus;
    private static final SessionStateEventBus sessionStateEventBus;
    private static final SessionStateManager sessionStateManager;
    private static MarkerSyncEngine markerSyncEngine;
    private static MarkReadEngine markReadEngine;
    @NotNull
    public static final CoreClient INSTANCE;

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"DateTime.now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        return sessionStateManager.getSessionState();
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint) {
        EkoApiKeyDao apiKeyDao;
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        CompletableSubject result = CompletableSubject.create();
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newSocketUrl = endpoint.getSocketEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        EkoApiKeyDao ekoApiKeyDao = apiKeyDao = EkoDatabase.get().apiKeyDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoApiKeyDao, (String)"apiKeyDao");
        MaybeSource maybeSource = (MaybeSource)ekoApiKeyDao.getCurrentApiKey();
        EkoHttpUrlDao ekoHttpUrlDao = httpUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoHttpUrlDao, (String)"httpUrlDao");
        MaybeSource maybeSource2 = (MaybeSource)ekoHttpUrlDao.getCurrentHttpUrl();
        EkoSocketUrlDao ekoSocketUrlDao = socketUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoSocketUrlDao, (String)"socketUrlDao");
        MaybeSource maybeSource3 = (MaybeSource)ekoSocketUrlDao.getCurrentSocketUrl();
        EkoMqttUrlDao ekoMqttUrlDao = mqttUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoMqttUrlDao, (String)"mqttUrlDao");
        Maybe.zip((MaybeSource)maybeSource, (MaybeSource)maybeSource2, (MaybeSource)maybeSource3, (MaybeSource)((MaybeSource)ekoMqttUrlDao.getCurrentMqttUrl()), (Function4)setup.1.INSTANCE).subscribeOn(Schedulers.io()).doOnSuccess((Consumer)new Consumer<Pair<? extends EkoApiKey, ? extends AmityEndpoint.CUSTOM>>(newHttpUrl, newSocketUrl, newMqttUrl, apiKey, httpUrlDao, socketUrlDao, mqttUrlDao, apiKeyDao){
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ String $apiKey;
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;

            public final void accept(@NotNull Pair<? extends EkoApiKey, ? extends AmityEndpoint> setupPair) {
                Intrinsics.checkNotNullParameter(setupPair, (String)"setupPair");
                String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
                String storedApiKey = string;
                String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
                String storedSocketUrl = ((AmityEndpoint)setupPair.getSecond()).getSocketEndpoint();
                String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
                if (!(Objects.equal((Object)storedHttpUrl, (Object)this.$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)this.$newSocketUrl) && Objects.equal((Object)storedMqttUrl, (Object)this.$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)this.$apiKey))) {
                    AmityLog.INSTANCE.tag("AmityCoreClient").e("Setup value changed. new api key: %s new http url: %s new socket url: %s new mqtt url: %s", new Object[]{this.$apiKey, this.$newHttpUrl, this.$newSocketUrl, this.$newMqttUrl});
                    AmityLog.INSTANCE.tag("AmityCoreClient").e("deleting user database", new Object[0]);
                    CoreClient.INSTANCE.logout();
                    this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                    this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                    this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                    this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                }
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$newHttpUrl = string;
                this.$newSocketUrl = string2;
                this.$newMqttUrl = string3;
                this.$apiKey = string4;
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$mqttUrlDao = ekoMqttUrlDao;
                this.$apiKeyDao = ekoApiKeyDao;
            }
        }).doOnComplete(new Action(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, mqttUrlDao, newMqttUrl, apiKeyDao, apiKey){
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;
            final /* synthetic */ String $apiKey;

            public final void run() {
                this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$newHttpUrl = string;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$newSocketUrl = string2;
                this.$mqttUrlDao = ekoMqttUrlDao;
                this.$newMqttUrl = string3;
                this.$apiKeyDao = ekoApiKeyDao;
                this.$apiKey = string4;
            }
        }).flatMapCompletable((Function)setup.4.INSTANCE).subscribe((CompletableObserver)result);
        this.setupSessionComponents();
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.setup(apiKey, AmityEndpoint.SG.INSTANCE);
    }

    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return this.registerPushNotification();
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return this.unregisterPushNotification();
    }

    @NotNull
    public final Completable registerPushNotification() {
        return new RegisterDeviceForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable unregisterPushNotification() {
        return new UnregisterAllUsersForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (mqttClient == null || socketClient == null) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"Completable.complete()");
        } else {
            EkoSocket ekoSocket = socketClient;
            if (ekoSocket != null) {
                ekoSocket.disconnect();
            }
            AmityMqttClient amityMqttClient = mqttClient;
            Intrinsics.checkNotNull((Object)amityMqttClient);
            completable = amityMqttClient.disconnect();
        }
        return completable;
    }

    @NotNull
    public final AmitySessionEstablisher.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        boolean isLegacyVersion;
        block2: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            boolean bl = isLegacyVersion = sessionHandler == null;
            if (this.getCurrentSessionState() instanceof SessionState.Establishing) {
                throw (Throwable)SessionError.INSTANCE.fromState(this.getCurrentSessionState());
            }
            SessionHandler sessionHandler2 = sessionHandler;
            if (sessionHandler2 == null) break block2;
            SessionHandler sessionHandler3 = sessionHandler2;
            boolean bl2 = false;
            boolean bl3 = false;
            SessionHandler it = sessionHandler3;
            boolean bl4 = false;
            TokenRenewalSessionComponent tokenRenewalSessionComponent = renewalManager;
            if (tokenRenewalSessionComponent != null) {
                tokenRenewalSessionComponent.setSessionHandler(it);
            }
        }
        return new AmitySessionEstablisher.Builder(appEventBus, sessionLifeCycleEventBus, userId, isLegacyVersion);
    }

    @NotNull
    public final Completable logout() {
        appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
        return new LogoutUseCase().execute();
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final AmityReactionRepository newReactionRepository() {
        return new AmityReactionRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "6.6.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return EkoSocket.Companion.getGlobalBanEvents();
    }

    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityNotification notifications() {
        return new AmityNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        return sessionStateEventBus.observe();
    }

    @NotNull
    public final Completable startReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.startReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.never()");
        }
        return markReadEngine;
    }

    @NotNull
    public final Completable stopReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.stopReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.never()");
        }
        return markReadEngine;
    }

    public final void startMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.startMarkerSync();
        }
    }

    public final void stopMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.stopMarkerSync();
        }
    }

    @NotNull
    public final Flowable<Integer> observeUserUnreadCount() {
        Flowable flowable = new ObserveUserMarker().execute().map((Function)observeUserUnreadCount.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ObserveUserMarker().exec\u2026().map { it.unreadCount }");
        return flowable;
    }

    private final void setupSessionComponents() {
        if (mqttClient == null || socketClient == null || renewalManager == null) {
            mqttClient = new AmityMqttClient(sessionLifeCycleEventBus, sessionStateEventBus);
            socketClient = new EkoSocket(sessionLifeCycleEventBus, sessionStateEventBus);
            renewalManager = new TokenRenewalSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
            new AmityHttpClient(sessionLifeCycleEventBus, sessionStateEventBus);
            new DatabaseSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new UserSettingSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new TokenWatcherSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
            markerSyncEngine = new MarkerSyncEngine(sessionLifeCycleEventBus, sessionStateEventBus);
            markReadEngine = new MarkReadEngine(sessionLifeCycleEventBus, sessionStateEventBus);
        }
    }

    private CoreClient() {
    }

    static {
        CoreClient coreClient;
        INSTANCE = coreClient = new CoreClient();
        sessionLifeCycleEventBus = new SessionLifeCycleEventBus();
        appEventBus = new AppEventBus();
        sessionStateEventBus = new SessionStateEventBus();
        SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
        SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
        sessionStateManager = new SessionStateManager(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
    }
}

