/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.marker.message;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.model.chat.message.MessageDeliveredMembershipFilter;
import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.MessageMarkerEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.MessageMarkerDao;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.functions.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000f0\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\nJ\u0014\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\nJ\u0014\u0010\u0018\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/marker/message/MessageMarkerLocalDataStore;", "", "()V", "getMessageDeliveredUsersPagingSource", "Landroidx/paging/PagingSource;", "", "Lcom/amity/socialcloud/sdk/entity/core/user/UserEntity;", "messageId", "", "memberships", "", "Lcom/amity/socialcloud/sdk/model/chat/message/MessageDeliveredMembershipFilter;", "getMessageMarker", "Lcom/ekoapp/ekosdk/internal/MessageMarkerEntity;", "getMessageReadUsersPagingSource", "Lcom/amity/socialcloud/sdk/model/chat/message/MessageReadMembershipFilter;", "saveAndUpdatePreviousMessageMarker", "", "marker", "saveAndUpdatePreviousMessageMarkers", "Lio/reactivex/rxjava3/core/Completable;", "messageMarkers", "saveLocalMessageMarkers", "markers", "saveMessageMarkers", "amity-sdk_release"})
public final class MessageMarkerLocalDataStore {
    @Nullable
    public final MessageMarkerEntity getMessageMarker(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return UserDatabase.get().messageMarkerDao().getByIdNow(messageId);
    }

    @NotNull
    public final Completable saveMessageMarkers(@NotNull List<? extends MessageMarkerEntity> messageMarkers) {
        Intrinsics.checkNotNullParameter(messageMarkers, (String)"messageMarkers");
        Completable completable = Completable.fromAction((Action)new Action(messageMarkers){
            final /* synthetic */ List $messageMarkers;

            public final void run() {
                UserDatabase.get().messageMarkerDao().save(this.$messageMarkers);
            }
            {
                this.$messageMarkers = list2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026messageMarkers)\n        }");
        return completable;
    }

    @NotNull
    public final Completable saveAndUpdatePreviousMessageMarkers(@NotNull List<? extends MessageMarkerEntity> messageMarkers) {
        Intrinsics.checkNotNullParameter(messageMarkers, (String)"messageMarkers");
        Completable completable = Completable.fromAction((Action)new Action(this, messageMarkers){
            final /* synthetic */ MessageMarkerLocalDataStore this$0;
            final /* synthetic */ List $messageMarkers;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$messageMarkers;
                MessageMarkerLocalDataStore messageMarkerLocalDataStore = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    MessageMarkerEntity messageMarkerEntity = (MessageMarkerEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    messageMarkerLocalDataStore.saveAndUpdatePreviousMessageMarker((MessageMarkerEntity)p1);
                    Unit unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
            {
                this.this$0 = messageMarkerLocalDataStore;
                this.$messageMarkers = list2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026sMessageMarker)\n        }");
        return completable;
    }

    public final void saveAndUpdatePreviousMessageMarker(@NotNull MessageMarkerEntity marker) {
        EkoMessageEntity message;
        EkoMessageEntity ekoMessageEntity;
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        EkoMessageDao messageDao = UserDatabase.get().messageDao();
        try {
            ekoMessageEntity = messageDao.getByMessageIdNow(marker.getMessageId());
        }
        catch (Exception e) {
            ekoMessageEntity = null;
        }
        EkoMessageEntity ekoMessageEntity2 = message = ekoMessageEntity;
        boolean isCreator = Intrinsics.areEqual((Object)(ekoMessageEntity2 != null ? ekoMessageEntity2.getUserId() : null), (Object)AmityCoreClient.INSTANCE.getUserId());
        MessageMarkerDao messageMarkerDao = UserDatabase.get().messageMarkerDao();
        if (isCreator) {
            messageMarkerDao.save(CollectionsKt.listOf((Object)marker));
        }
        String string = marker.getSubChannelId();
        int n = marker.getReadCount();
        DateTime dateTime = marker.getCreatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"marker.createdAt");
        messageMarkerDao.updatePreviousMarkersReadCount(string, n, dateTime);
        String string2 = marker.getSubChannelId();
        int n2 = marker.getDeliveredCount();
        DateTime dateTime2 = marker.getCreatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"marker.createdAt");
        messageMarkerDao.updatePreviousMarkersDeliveredCount(string2, n2, dateTime2);
    }

    public final void saveLocalMessageMarkers(@NotNull List<? extends MessageMarkerEntity> markers) {
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        UserDatabase.get().messageMarkerDao().save(markers);
    }

    @NotNull
    public final PagingSource<Integer, UserEntity> getMessageReadUsersPagingSource(@NotNull String messageId, @NotNull List<? extends MessageReadMembershipFilter> memberships) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        return UserDatabase.get().messageReadUsersPagingDao().getMessageReadUsersPagingSource(messageId, memberships);
    }

    @NotNull
    public final PagingSource<Integer, UserEntity> getMessageDeliveredUsersPagingSource(@NotNull String messageId, @NotNull List<? extends MessageDeliveredMembershipFilter> memberships) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        return UserDatabase.get().messageDeliveredUsersPagingDao().getMessageDeliveredUsersPagingSource(messageId, memberships);
    }
}

