package com.amity.socialcloud.sdk.core.data.follow.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.core.data.follow.FollowQueryPersister
import com.amity.socialcloud.sdk.core.data.follow.FollowRemoteDataStore
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowQueryDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity
import com.ekoapp.ekosdk.internal.mediator.DynamicQueryStreamMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Flowable
import io.reactivex.Single

class BlockedMediator(
    val userId: String
) : DynamicQueryStreamMediator<EkoUserFollowStatusEntity, EkoFollowQueryDto, AmityFollowRelationship>(
    nonce = AmityNonce.BLOCKED_LIST,
    dynamicQueryStreamKeyCreator = BlockedKeyCreator(
        userId = userId
    )
) {

    override fun provideReactorPublisher(): Flowable<AmityFollowRelationship> {
        return Flowable.empty()
    }

    override fun getFirstPageRequest(pageSize: Int): Single<EkoFollowQueryDto> {
        return getRequest(limit = pageSize)
    }

    override fun getFetchByTokenRequest(token: String): Single<EkoFollowQueryDto> {
        return getRequest(token = token)
    }

    override fun convertResponseToQueryToken(dto: EkoFollowQueryDto): QueryStreamQueryToken {
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            next = dto.paging?.next,
            previous = dto.paging?.previous,
            primaryKeys = dto.follows.map { it.getId() }
        )
    }

    override fun persistResponse(dto: EkoFollowQueryDto): Completable {
        return FollowQueryPersister().persist(dto).toRx2()
    }

    private fun getRequest(
        limit: Int? = null,
        token: String? = null
    ): Single<EkoFollowQueryDto> {
        return FollowRemoteDataStore().getBlockedUsers(
            limit = limit,
            token = token
        ).toRx2()
    }

}