package com.amity.socialcloud.sdk.api.video.stream

import com.amity.socialcloud.sdk.api.video.stream.query.AmityStreamQuery
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import com.amity.socialcloud.sdk.video.domain.stream.CreateStreamUseCase
import com.amity.socialcloud.sdk.video.domain.stream.DisposeStreamBroadcasterUseCase
import com.amity.socialcloud.sdk.video.domain.stream.FetchStreamUseCase
import com.amity.socialcloud.sdk.video.domain.stream.GetStreamUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single

class AmityStreamRepository internal constructor() {
    
    /* begin_public_function
      id: stream.query
      api_style: live_collection
    */
    fun getStreams(): AmityStreamQuery.Builder {
        return AmityStreamQuery.Builder()
    }
    /* end_public_function */

    fun fetchStream(streamId: String): Completable {
        return FetchStreamUseCase().execute(streamId)
    }
    
    /* begin_public_function
      id: stream.get
    */
    fun getStream(streamId: String): Flowable<AmityStream> {
        return GetStreamUseCase().execute(streamId)
    }
    /* end_public_function */

    @Deprecated("Use getStream(streamId: String) instead")
    fun observeStream(streamId: String): Flowable<AmityStream> {
        return getStream(streamId)
    }
    
    /* begin_public_function
      id: stream.create
    */
    fun createStream(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null,
        isSecure: Boolean? = null
    ): Single<AmityStream> {
        return CreateStreamUseCase().execute(
            title = title,
            description = description,
            resolution = resolution,
            thumbnailFileId = thumbnailFileId,
            isSecure = isSecure
        )
    }
    /* end_public_function */

    @Deprecated("Use createStream(...) instead")
    fun createVideoStream(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null,
        isSecure: Boolean? = null,
    ): Single<AmityStream> {
        return createStream(
            title = title,
            description = description,
            resolution = resolution,
            thumbnailFileId = thumbnailFileId,
            isSecure = isSecure
        )
    }

    /* begin_public_function
      id: stream.dispose
    */
    fun disposeStream(streamId: String): Completable {
        return DisposeStreamBroadcasterUseCase().execute(streamId)
    }
    /* end_public_function */

}