package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.model.core.events.AmityPostEvents
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import io.reactivex.rxjava3.core.Single

internal class PostTopicGeneratorUseCase : TopicGenerationUseCase() {

    fun execute(post: AmityPost, events: AmityPostEvents) : Single<String> {
        val topic = when (events) {
            AmityPostEvents.POST -> {
                post.path
            }
            AmityPostEvents.COMMENTS -> {
                post.path + "/comment/+"
            }
        }
        return Single.just(topic)
    }

}