package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.socket.util.EkoGson.get
import com.ekoapp.ekosdk.EkoFlag

class EkoFlagTypeConverter {
	@TypeConverter
	fun stringToEkoFlag(json: String?): EkoFlag? {
		return json?.let { get().fromJson(it, EkoFlag::class.java) }
	}
	
	@TypeConverter
	fun ekoFlagToString(flag: EkoFlag?): String? {
		return flag?.let(get()::toJson)
	}
}