package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoPollQueryDto
import io.reactivex.rxjava3.core.Completable

internal class PollQueryPersister : QueryPersister<EkoPollQueryDto>() {

    override fun persist(dto: EkoPollQueryDto): Completable {
        return UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
            .andThen(PollLocalDataStore().savePolls(PollEntityMapper().map(dto.polls)))
    }
}