package com.amity.socialcloud.sdk.chat.domain.subchannel

import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel
import io.reactivex.rxjava3.core.Single

class SubChannelCreateUseCase {

    fun execute(
        channelId: String,
        displayName: String
    ): Single<AmitySubChannel> {
        return SubChannelRepository()
                .createSubChannel(channelId, displayName)
                .map(SubChannelComposerUseCase()::execute)
    }
    
}